/*
 * DialogHandler.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1998-2002 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.1
 * Created by suhler on 98/12/04
 * Last modified by suhler on 02/10/01 16:36:29
 */

package sunlabs.brazil.handler;

import java.awt.Button;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.io.IOException;
import sunlabs.brazil.server.Handler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;

/**
 * Sample handler for popping up a dialog box on the server.
 * This is used for interactive authentication of web pages, allowing
 * an <i>operator</i> on the server's computer to allow or deny access
 * to pages on a per request basis.
 * Input parameters examined in the request properties:
 * <dl class=props>
 * <dt>prefix, suffix, glob, match
 * <dd>Specify the URL that triggers this handler.
 * (See {@link MatchString}).
 * <dt>default<dd>The message to appear in the dialog box.
 * Defaults to <b>Request from Client</b>.
 * <dt>denied<dd>The message to appear in the "permission denied" spot.
 * </dl>
 * If query data is present, it is used as the message.
 * <p>
 * Note:  This is the only class in the entire system that requires AWT.
 *
 * @author      Stephen Uhler
 * @version     2.1, 02/10/01
 */

public class DialogHandler extends java.applet.Applet implements Handler {

/*
 * The user interface components
 */

/**
 * @serial
 */
public Panel frame_1;

/**
 * @serial
 */
public Button ok;

/**
 * @serial
 */
public Label title;

/**
 * @serial
 */
public Button cancel;

MatchString isMine;            // check for matching url
String prefix;		// my properties prefix

/**
 * @serial
 */
Frame f;		// The dialog box

/**
 * @serial
 */
Dimension screen;	// The screen dimentions - so we can do centering

/**
 * @serial
 */
boolean abort;		// True if the user hit "cancel"

/**
 * @serial
 */
String message = "User Request for URL";		// Default message

/**
 * Do one time initialization.
 */
public boolean
init(Server server, String prefix) {
    this.prefix = prefix;
    isMine = new MatchString(prefix);
    f = new Frame("Message from Client");
    screen = f.getToolkit().getScreenSize();
    init();
    f.add("Center", this);
    f.pack();
    return true;
}

/**
 * Pop up a dialog box on the server machine.
 * Allow the operator to select <b>yes</b> or <b>no</b>.
 * If the request is allowed, it is passed on to the next handler.
 */

public boolean
respond(Request request) throws IOException {
    if (!isMine.match(request.url, request.props)) {
        return false;
    }
    message = request.props.getProperty(prefix + "default",
	"Request from Client");
    String denied = request.props.getProperty(prefix + "denied",
	"<title>denied!</title>Requested URL denied by server");
    if (request.query.length() == 0) {
	title.setText(message);
    } else {
	title.setText(request.query);
    }
    Dimension size = f.getSize();
    try {
	synchronized (f) {
	    f.setVisible(true);
	    f.setLocation((screen.width-size.width)/2,
	    		(screen.height-size.height)/2);
	    while (f.isVisible()) {
		f.wait();
	    }
	}
    } catch (InterruptedException e) {
    	request.log(Server.LOG_WARNING,"Got: " + e);
    }
    if (abort) {
        request.sendResponse(denied, "text/html", 404);
        return true;
    } else {
	return false;
    }
}

public void dismiss(boolean how) {
    synchronized (f) {
    	abort = !how;
    	f.setVisible(false);
    	f.notifyAll();
    }
}

/**
 * Machine generated code.
 * Everything after here was automatically generated
 * SpecTcl generated class Dialog, version 1.0
 */

public void init() {
	// main panel
	GridBagLayout grid = new GridBagLayout();
	int rowHeights[] = {0,30,20};
	int columnWidths[] = {0,30};
	double rowWeights[] = {0.0,0.0,0.0};
	double columnWeights[] = {0.0,0.0};
	grid.rowHeights = rowHeights;
	grid.columnWidths = columnWidths;
	grid.rowWeights = rowWeights;
	grid.columnWeights = columnWeights;

	// container frame_1 in this.
	GridBagLayout frame_1_grid = new GridBagLayout();
	int frame_1_rowHeights[] = {0,14};
	int frame_1_columnWidths[] = {0,30,30};
	double frame_1_rowWeights[] = {0.0,0.0};
	double frame_1_columnWeights[] = {0.0,0.0,0.0};
	frame_1_grid.rowHeights = frame_1_rowHeights;
	frame_1_grid.columnWidths = frame_1_columnWidths;
	frame_1_grid.rowWeights = frame_1_rowWeights;
	frame_1_grid.columnWeights = frame_1_columnWeights;

	frame_1 = new Panel();
	this.add(frame_1);
	
	ok = new Button();
	ok.setLabel("OK");
	frame_1.add(ok);
	
	title = new Label();
	title.setFont(new Font("Helvetica",Font.PLAIN + Font.BOLD , 18));
	title.setText(message);
	title.setAlignment(Label.CENTER);
	this.add(title);
	
	cancel = new Button();
	cancel.setLabel("Cancel");
	frame_1.add(cancel);
	
	// Geometry management
	GridBagConstraints con = new GridBagConstraints();
	reset(con);
	con.gridx = 1;
	con.gridy = 2;
	con.anchor = GridBagConstraints.CENTER;
	con.fill = GridBagConstraints.NONE;
	grid.setConstraints(frame_1, con);

	reset(con);
	con.gridx = 1;
	con.gridy = 1;
	con.anchor = GridBagConstraints.CENTER;
	con.fill = GridBagConstraints.NONE;
	frame_1_grid.setConstraints(ok, con);

	reset(con);
	con.gridx = 1;
	con.gridy = 1;
	con.anchor = GridBagConstraints.CENTER;
	con.fill = GridBagConstraints.NONE;
	grid.setConstraints(title, con);

	reset(con);
	con.gridx = 2;
	con.gridy = 1;
	con.anchor = GridBagConstraints.CENTER;
	con.fill = GridBagConstraints.NONE;
	frame_1_grid.setConstraints(cancel, con);

	// Resize behavior management and parent heirarchy
	setLayout(grid);
	frame_1.setLayout(frame_1_grid);
}

public boolean handleEvent(Event event) {
	if (event.target == ok && event.id == event.ACTION_EVENT) {
		dismiss(true);
	} else if (event.target == cancel && event.id == event.ACTION_EVENT) {
		dismiss(false);
	} else {
		return super.handleEvent(event);
	}
	return true;
}

private void reset(GridBagConstraints con) {
    con.gridx = GridBagConstraints.RELATIVE;
    con.gridy = GridBagConstraints.RELATIVE;
    con.gridwidth = 1;
    con.gridheight = 1;
 
    con.weightx = 0;
    con.weighty = 0;
    con.anchor = GridBagConstraints.CENTER;
    con.fill = GridBagConstraints.NONE;
 
    con.insets = new Insets(0, 0, 0, 0);
    con.ipadx = 0;
    con.ipady = 0;
}
}
