(set-option :print-success false)
(set-option :produce-interpolants true)
(set-option :proof-transformation LURPI)
(set-option :interpolant-check-mode true)
(set-option :verbosity 3)
(set-info :source "{
Test formula which needs AB-mixed interpolators
An interpolant is
    (and (<= s2 s1) (or (< s2 s1) (and (= y1 (f s1)) (= y1 (f s1)))))
}")
(set-info :status unsat)
(set-info :difficulty "{ 0 }")
(set-logic QF_UFLRA)
(declare-fun a1 () Real)
(declare-fun a2 () Real)
(declare-fun b1 () Real)
(declare-fun b2 () Real)
(declare-fun s1 () Real)
(declare-fun s2 () Real)
(declare-fun y1 () Real)
(declare-fun y2 () Real)
(declare-fun f (Real) Real)
;a1 <= s1 <= b1 <= b2 <= s2 <= a2 <= a1
(assert (! (and (<= s2 a2) (<= a2 a1) (<= a1 s1)
	     	(= (f a1) y1) (= (f a2) y2)) :named A))
(assert (! (and (<= s1 b1) (<= b1 b2) (<= b2 s2)
	        (or (distinct (f b1) y1) 
		    (distinct (f b1) y2) 
		    (distinct (f b2) y1) 
		    (distinct (f b2) y2))) :named B))
(check-sat)
(get-interpolants A B)
(exit)
