/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.Grammar;
import com.github.jhoenicke.javacup.lalr_transition;
import com.github.jhoenicke.javacup.lookaheads;
import com.github.jhoenicke.javacup.lr_item;
import com.github.jhoenicke.javacup.non_terminal;
import com.github.jhoenicke.javacup.parse_action_table;
import com.github.jhoenicke.javacup.parse_reduce_table;
import com.github.jhoenicke.javacup.production;
import com.github.jhoenicke.javacup.symbol;
import com.github.jhoenicke.javacup.terminal;
import com.github.jhoenicke.javacup.terminal_set;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;

public class lalr_state {
    private TreeMap<lr_item, lookaheads> _items;
    private lalr_transition _transitions = null;
    private int _index;

    public lalr_state(Map<lr_item, terminal_set> map, int n) {
        if (map == null) {
            throw new AssertionError((Object)"Attempt to construct an LALR state from a null item set");
        }
        this._index = n;
        this._items = new TreeMap();
        for (Map.Entry<lr_item, terminal_set> entry : map.entrySet()) {
            this._items.put(entry.getKey(), new lookaheads(entry.getValue()));
        }
    }

    public TreeMap<lr_item, lookaheads> items() {
        return this._items;
    }

    public int index() {
        return this._index;
    }

    public void compute_closure(Grammar grammar) {
        Stack<lr_item> stack = new Stack<lr_item>();
        stack.addAll(this._items.keySet());
        while (stack.size() > 0) {
            lr_item lr_item2 = (lr_item)stack.pop();
            non_terminal non_terminal2 = lr_item2.dot_before_nt();
            if (non_terminal2 == null) continue;
            lr_item lr_item3 = lr_item2.shift_item();
            terminal_set terminal_set2 = lr_item3.calc_lookahead(grammar);
            boolean bl = lr_item3.is_nullable();
            if (bl) {
                terminal_set2.add(this._items.get(lr_item2));
            }
            for (production production2 : non_terminal2.productions()) {
                lookaheads lookaheads2;
                lr_item lr_item4 = production2.item();
                if (this._items.containsKey(lr_item4)) {
                    lookaheads2 = this._items.get(lr_item4);
                    lookaheads2.add(terminal_set2);
                } else {
                    lookaheads2 = new lookaheads(terminal_set2);
                    this._items.put(lr_item4, lookaheads2);
                    stack.push(lr_item4);
                }
                if (!bl) continue;
                this._items.get(lr_item2).add_listener(lookaheads2);
            }
        }
    }

    public void compute_successors(Grammar grammar) {
        Object object;
        TreeMap treeMap = new TreeMap();
        for (Comparable<lr_item> comparable : this._items.keySet()) {
            object = comparable.symbol_after_dot();
            if (object == null) continue;
            if (!treeMap.containsKey(object)) {
                treeMap.put((symbol)object, new ArrayList());
            }
            ((ArrayList)treeMap.get(object)).add(comparable);
        }
        for (Comparable<lr_item> comparable : treeMap.keySet()) {
            Comparable<symbol> comparable2;
            object = new TreeMap();
            ArrayList<Comparable<symbol>> arrayList = new ArrayList<Comparable<symbol>>();
            arrayList.add(comparable);
            for (int i = 0; i < arrayList.size(); ++i) {
                symbol symbol2 = (symbol)arrayList.get(i);
                for (Object object2 : (ArrayList)treeMap.get(symbol2)) {
                    if (((lr_item)object2).the_production.is_proxy()) {
                        comparable2 = ((lr_item)object2).the_production.lhs();
                        if (arrayList.contains(comparable2)) continue;
                        arrayList.add(comparable2);
                        continue;
                    }
                    ((TreeMap)object).put(((lr_item)object2).shift_item(), (terminal_set)this.items().get(object2));
                }
            }
            lalr_state lalr_state2 = grammar.get_lalr_state((Map<lr_item, terminal_set>)object);
            for (symbol symbol2 : arrayList) {
                Object object2;
                object2 = ((ArrayList)treeMap.get(symbol2)).iterator();
                while (object2.hasNext()) {
                    comparable2 = (lr_item)object2.next();
                    if (((lr_item)comparable2).the_production.is_proxy()) continue;
                    this.items().get(comparable2).add_listener(lalr_state2.items().get(((lr_item)comparable2).shift_item()));
                }
            }
            this._transitions = new lalr_transition((symbol)comparable, lalr_state2, this._transitions);
        }
    }

    public void propagate_lookaheads(Map<lr_item, terminal_set> map) {
        for (Map.Entry<lr_item, terminal_set> entry : map.entrySet()) {
            this._items.get(entry.getKey()).add(entry.getValue());
        }
    }

    public void build_table_entries(Grammar grammar, parse_action_table parse_action_table2, parse_reduce_table parse_reduce_table2, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = false;
        int[] nArray = parse_action_table2.table[this.index()];
        production[] productionArray = new production[grammar.num_terminals() + 1];
        lalr_state[] lalr_stateArray = parse_reduce_table2.table[this.index()];
        for (Map.Entry<lr_item, lookaheads> entry : this.items().entrySet()) {
            production production2;
            if (!entry.getKey().dot_at_end()) continue;
            boolean bl3 = false;
            n = parse_action_table.action(2, entry.getKey().the_production.action_index());
            int n4 = 0;
            for (int i = 0; i < grammar.num_terminals(); ++i) {
                if (!entry.getValue().contains(i)) continue;
                ++n4;
                if (nArray[i] == 0) {
                    nArray[i] = n;
                    productionArray[i] = entry.getKey().the_production;
                    continue;
                }
                bl3 = true;
            }
            if (bl3) {
                for (Map.Entry<lr_item, lookaheads> entry2 : this.items().entrySet()) {
                    if (entry.getKey() == entry2.getKey()) break;
                    if (!entry2.getKey().dot_at_end() || !entry2.getValue().intersects(entry.getValue())) continue;
                    grammar.report_reduce_reduce(this, entry2, entry);
                }
            }
            if (!bl || n4 <= n2 || (production2 = entry.getKey().the_production).rhs_length() == 0 && n4 <= 1) continue;
            bl2 = production2.rhs_length() == 0;
            n2 = n4;
            n3 = n;
        }
        Object object = this._transitions;
        while (object != null) {
            symbol symbol2 = ((lalr_transition)object).on_symbol;
            int n5 = symbol2.index();
            if (!symbol2.is_non_term()) {
                n = parse_action_table.action(1, ((lalr_transition)object).to_state.index());
                if (nArray[n5] == 0) {
                    nArray[symbol2.index()] = n;
                } else {
                    production production3 = productionArray[n5];
                    if (!this.fix_with_precedence(production3, (terminal)symbol2, nArray, n)) {
                        nArray[n5] = n;
                        grammar.report_shift_reduce(this, production3, symbol2);
                    }
                }
            } else {
                lalr_stateArray[n5] = ((lalr_transition)object).to_state;
            }
            object = ((lalr_transition)object).next;
        }
        n = nArray[terminal.error.index()];
        if (n != 0) {
            n3 = parse_action_table.isReduce(n) ? n : 0;
            bl2 = false;
        }
        nArray[grammar.num_terminals()] = n3;
        if (n3 != 0) {
            for (int i = 0; i < grammar.num_terminals(); ++i) {
                if (nArray[i] != 0 || i == terminal.error.index() && bl2) continue;
                nArray[i] = n3;
            }
        }
    }

    private boolean fix_with_precedence(production production2, terminal terminal2, int[] nArray, int n) {
        if (production2.precedence_num() > -1 && terminal2.precedence_num() > -1) {
            int n2 = terminal2.precedence_num() - production2.precedence_num();
            if (n2 == 0) {
                n2 = terminal2.precedence_side() - 1;
            }
            if (n2 < 0) {
                return true;
            }
            if (n2 > 0) {
                nArray[terminal2.index()] = n;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lalr_state [").append(this.index()).append("]: {\n");
        for (Map.Entry<lr_item, lookaheads> entry : this.items().entrySet()) {
            if (entry.getKey().dot_pos == 0) continue;
            stringBuilder.append("  [").append(entry.getKey()).append(", ");
            stringBuilder.append(entry.getValue()).append("]\n");
        }
        for (Map.Entry<lr_item, lookaheads> entry : this.items().entrySet()) {
            if (entry.getKey().dot_pos != 0) continue;
            stringBuilder.append("  [").append(entry.getKey()).append(", ");
            stringBuilder.append(entry.getValue()).append("]\n");
        }
        stringBuilder.append("}\n");
        lalr_transition lalr_transition2 = this._transitions;
        while (lalr_transition2 != null) {
            stringBuilder.append(lalr_transition2).append("\n");
            lalr_transition2 = lalr_transition2.next;
        }
        return stringBuilder.toString();
    }
}

