---
title: pixi upload prefix
---
<!--- This file is autogenerated. Do not edit manually! -->
# [pixi](../../pixi.md) [upload](../upload.md) prefix

Options for uploading to a prefix.dev server. Authentication is used from the keychain / auth-file

--8<-- "docs/reference/cli/pixi/upload/prefix_extender:description"

## Usage
```
pixi upload prefix [OPTIONS] --channel <CHANNEL>
```

## Options
- <a id="arg---url" href="#arg---url">`--url (-u) <URL>`</a>
:  The URL to the prefix.dev server (only necessary for self-hosted instances)
<br>**env**: `PREFIX_SERVER_URL`
<br>**default**: `https://prefix.dev`
- <a id="arg---channel" href="#arg---channel">`--channel (-c) <CHANNEL>`</a>
:  The channel to upload the package to
<br>**required**: `true`
<br>**env**: `PREFIX_CHANNEL`
- <a id="arg---api-key" href="#arg---api-key">`--api-key (-a) <API_KEY>`</a>
:  The prefix.dev API key, if none is provided, the token is read from the keychain / auth-file
<br>**env**: `PREFIX_API_KEY`
- <a id="arg---attestation" href="#arg---attestation">`--attestation <ATTESTATION>`</a>
:  Upload an attestation file alongside the package. Note: if you add an attestation, you can _only_ upload a single package. Mutually exclusive with --generate-attestation
- <a id="arg---generate-attestation" href="#arg---generate-attestation">`--generate-attestation`</a>
:  Automatically generate attestation using cosign in CI. Mutually exclusive with --attestation
- <a id="arg---skip-existing" href="#arg---skip-existing">`--skip-existing (-s)`</a>
:  Skip upload if package already exists
- <a id="arg---force" href="#arg---force">`--force`</a>
:  Force overwrite existing packages

--8<-- "docs/reference/cli/pixi/upload/prefix_extender:example"
