# Mainboard-specific documentation

This section contains documentation about coreboot on specific mainboards.

## 51NB

- [X210](51nb/x210.md)

## Acer

- [G43T-AM3](acer/g43t-am3.md)

## AMD
- [pademelon](amd/pademelon/pademelon.md)

## ASRock

- [H77 Pro4-M](asrock/h77pro4-m.md)
- [H81M-HDS](asrock/h81m-hds.md)
- [H110M-DVS](asrock/h110m-dvs.md)

## ASUS

- [A88XM-E](asus/a88xm-e.md)
- [F2A85-M](asus/f2a85-m.md)
- [P5Q](asus/p5q.md)
- [P8C WS](asus/p8c_ws.md)
- [P8H61-M LX](asus/p8h61-m_lx.md)
- [P8H61-M Pro](asus/p8h61-m_pro.md)
- [P8H77-V](asus/p8h77-v.md)
- [P8Z77-M Pro](asus/p8z77-m_pro.md)
- [P8Z77-V](asus/p8z77-v.md)
- [wifigo_v1](asus/wifigo_v1.md)

## Cavium

- [CN81XX EVB SFF](cavium/cn8100_sff_evb.md)

## Clevo

- [N130WU / N131WU](clevo/n130wu/index.md)

## Dell

- [OptiPlex 9010 SFF](dell/optiplex_9010.md)

## Emulation

The boards in this section are not real mainboards, but emulators.

- [Spike RISC-V emulator](emulation/spike-riscv.md)
- [QEMU RISC-V emulator](emulation/qemu-riscv.md)
- [QEMU AArch64 emulator](emulation/qemu-aarch64.md)
- [QEMU x86 Q35](emulation/qemu-q35.md)
- [QEMU x86 PC](emulation/qemu-i440fx.md)
- [QEMU POWER9](emulation/qemu-power9.md)

## Facebook

- [FBG-1701](facebook/fbg1701.md)
- [Monolith](facebook/monolith.md)

## Foxconn

- [D41S](foxconn/d41s.md)

## Gigabyte

- [GA-G41M-ES2L](gigabyte/ga-g41m-es2l.md)
- [GA-H61M-S2PV](gigabyte/ga-h61m-s2pv.md)

## HP

- [Compaq 8200 Elite SFF](hp/compaq_8200_sff.md)
- [Z220 Workstation SFF](hp/z220_sff.md)

### EliteBook series

- [HP Laptops with KBC1126 EC](hp/hp_kbc1126_laptops.md)
- [HP Sure Start](hp/hp_sure_start.md)
- [EliteBook 2560p](hp/2560p.md)
- [EliteBook 8760w](hp/8760w.md)
- [EliteBook Folio 9480m](hp/folio_9480m.md)

## Intel

- [DG43GT](intel/dg43gt.md)
- [IceLake RVP](intel/icelake_rvp.md)
- [KBLRVP11](intel/kblrvp11.md)

## Kontron

- [mAL-10](kontron/mal10.md)

## Lenovo

- [Mainboard codenames](lenovo/codenames.md)
- [Hardware Maintenance Manual of ThinkPads](lenovo/thinkpad_hmm.md)
- [R60](lenovo/r60.md)
- [T4xx common](lenovo/t4xx_series.md)
- [X2xx common](lenovo/x2xx_series.md)
- [vboot](lenovo/vboot.md)

### GM45 series

- [X200 / T400 / T500 / X301 common](lenovo/montevina_series.md)
- [X301](lenovo/x301.md)

### Arrandale series

- [T410](lenovo/t410.md)

### Sandy Bridge series

- [T420](lenovo/t420.md)
- [T420 / T520 / X220 / T420s / W520 common](lenovo/Sandy_Bridge_series.md)
- [X1](lenovo/x1.md)

### Ivy Bridge series

- [T430](lenovo/t430.md)
- [T530](lenovo/w530.md)
- [W530](lenovo/w530.md)
- [T430 / T530 / X230 / W530 common](lenovo/Ivy_Bridge_series.md)
- [T431s](lenovo/t431s.md)
- [X230s](lenovo/x230s.md)
- [Internal flashing](lenovo/ivb_internal_flashing.md)

### Haswell series

- [T440p](lenovo/t440p.md)

## Libretrend

- [LT1000](libretrend/lt1000.md)

## MSI

- [MS-7707](msi/ms7707/ms7707.md)

## OCP

- [Delta Lake](ocp/deltalake.md)
- [Tioga Pass](ocp/tiogapass.md)

## Open Cellular

- [Elgon](opencellular/elgon.md)

## PC Engines

- [APU1](pcengines/apu1.md)
- [APU2](pcengines/apu2.md)

## Portwell

- [PQ7-M107](portwell/pq7-m107.md)

## Prodrive

- [Hermes](prodrive/hermes.md)

## Purism

- [Librem 14](purism/librem_14.md)
- [Librem Mini](purism/librem_mini.md)

## Protectli

- [FW2B / FW4B](protectli/fw2b_fw4b.md)
- [FW6A / FW6B / FW6C](protectli/fw6.md)

## Roda

- [RK9 Flash Header](roda/rk9/flash_header.md)

## SiFive

- [SiFive HiFive Unleashed](sifive/hifive-unleashed.md)

## Star Labs Systems

- [LabTop Mk III](starlabs/labtop_kbl.md)
- [LabTop Mk IV](starlabs/labtop_cml.md)
- [StarLite Mk III](starlabs/lite_glk.md)
- [StarLite Mk IV](starlabs/lite_glkr.md)
- [StarBook Mk V](starlabs/starbook_tgl.md)
- [Flashing devices](starlabs/common/flashing.md)

## Supermicro

- [X9SAE](supermicro/x9sae.md)
- [X10SLM+-F](supermicro/x10slm-f.md)
- [X11 LGA1151 series](supermicro/x11-lga1151-series/x11-lga1151-series.md)
- [Flashing using the BMC](supermicro/flashing_on_vendorbmc.md)

## System76

- [Adder Workstation 1](system76/addw1.md)
- [Adder Workstation 2](system76/addw2.md)
- [Bonobo Workstation 14](system76/bonw14.md)
- [Darter Pro 6](system76/darp6.md)
- [Darter Pro 7](system76/darp7.md)
- [Galago Pro 4](system76/galp4.md)
- [Galago Pro 5](system76/galp5.md)
- [Gazelle 15](system76/gaze15.md)
- [Gazelle 16](system76/gaze16.md)
- [Lemur Pro 9](system76/lemp9.md)
- [Lemur Pro 10](system76/lemp10.md)
- [Oryx Pro 5](system76/oryp5.md)
- [Oryx Pro 6](system76/oryp6.md)
- [Oryx Pro 7](system76/oryp7.md)
- [Oryx Pro 8](system76/oryp8.md)

## Texas Instruments

- [Beaglebone Black](ti/beaglebone-black.md)

## UP

- [Squared](up/squared/index.md)
