/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.scala.systemd;

import eu.geekplace.scala.systemd.Systemd$;
import eu.geekplace.scala.systemd.Systemd$ActiveTimer$;
import java.io.Serializable;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import jnr.ffi.Pointer;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.types.Variant;
import org.freedesktop.systemd1.ListUnitsByPatternsStruct;
import org.freedesktop.systemd1.ListUnitsStruct;
import org.freedesktop.systemd1.Manager;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.runtime.Statics;

public class Systemd {
    private final DBusConnection sessionConnection;
    private final Manager manager;
    private final String TIMER_UNIT_EXT;

    public static boolean isRunningUnderSystemd() {
        return Systemd$.MODULE$.isRunningUnderSystemd();
    }

    public static Interface libSystemd() {
        return Systemd$.MODULE$.libSystemd();
    }

    public static void notifyReady() {
        Systemd$.MODULE$.notifyReady();
    }

    public static void notifyWatchdog() {
        Systemd$.MODULE$.notifyWatchdog();
    }

    public Systemd(DBusConnection sessionConnection) {
        this.sessionConnection = sessionConnection;
        this.manager = sessionConnection.getRemoteObject("org.freedesktop.systemd1", "/org/freedesktop/systemd1", Manager.class);
        this.TIMER_UNIT_EXT = ".timer";
    }

    public DBusConnection sessionConnection() {
        return this.sessionConnection;
    }

    public Manager manager() {
        return this.manager;
    }

    public List<ListUnitsStruct> getUnits() {
        return this.manager().ListUnits();
    }

    public Buffer<ActiveTimer> getActiveTimers() {
        List<String> states = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"active"), Nil$.MODULE$))).asJava();
        List<String> patterns = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"*.timer"), Nil$.MODULE$))).asJava();
        Buffer<ListUnitsByPatternsStruct> activeTimers = CollectionConverters$.MODULE$.ListHasAsScala(this.manager().ListUnitsByPatterns(states, patterns)).asScala();
        return (Buffer)((IterableOps)activeTimers.map((Function1<ListUnitsByPatternsStruct, Tuple3> & Serializable)activeTimer -> {
            String busPath = activeTimer.getObjectPath().toString();
            Map properties = CollectionConverters$.MODULE$.MapHasAsScala(this.sessionConnection().getRemoteObject("org.freedesktop.systemd1", busPath, Properties.class).GetAll("org.freedesktop.systemd1.Timer")).asScala().toMap($less$colon$less$.MODULE$.refl());
            return Tuple3$.MODULE$.apply(activeTimer, busPath, properties);
        })).map((Function1<Tuple3, ActiveTimer> & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                ListUnitsByPatternsStruct activeTimer = (ListUnitsByPatternsStruct)tuple3._1();
                String busPath = (String)tuple3._2();
                Map properties = (Map)tuple3._3();
                return Systemd$ActiveTimer$.MODULE$.apply(activeTimer, properties);
            }
            throw new MatchError(tuple3);
        });
    }

    public String TIMER_UNIT_EXT() {
        return this.TIMER_UNIT_EXT;
    }

    public Option<ActiveTimer> getEarliestTimer(scala.collection.immutable.Seq<String> timers) {
        Buffer matchingTimers = (Buffer)this.getActiveTimers().filter((Function1<ActiveTimer, boolean> & Serializable)t -> {
            String unitName = t._1().getUnitName();
            if (unitName.endsWith(this.TIMER_UNIT_EXT())) {
                String timerName = unitName.substring(0, unitName.length() - this.TIMER_UNIT_EXT().length());
                return timers.contains(timerName);
            }
            return false;
        });
        return ((IterableOps)matchingTimers.sortBy((Function1<ActiveTimer, Instant> & Serializable)_$1 -> _$1._3(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).headOption();
    }

    public static class ActiveTimer
    implements Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ActiveTimer.class.getDeclaredField("localTime$lzy1"));
        private final ListUnitsByPatternsStruct unit;
        private final Map<String, Variant<?>> properties;
        private final Instant instant;
        private final boolean persistent;
        private volatile Object localTime$lzy1;

        public static ActiveTimer apply(ListUnitsByPatternsStruct listUnitsByPatternsStruct, Map<String, Variant<?>> map) {
            return Systemd$ActiveTimer$.MODULE$.apply(listUnitsByPatternsStruct, map);
        }

        public static ActiveTimer apply(ListUnitsByPatternsStruct listUnitsByPatternsStruct, Map<String, Variant<?>> map, Instant instant, boolean bl) {
            return Systemd$ActiveTimer$.MODULE$.apply(listUnitsByPatternsStruct, map, instant, bl);
        }

        public static ActiveTimer fromProduct(Product product) {
            return Systemd$ActiveTimer$.MODULE$.fromProduct(product);
        }

        public static ActiveTimer unapply(ActiveTimer activeTimer) {
            return Systemd$ActiveTimer$.MODULE$.unapply(activeTimer);
        }

        public ActiveTimer(ListUnitsByPatternsStruct unit, Map<String, Variant<?>> properties, Instant instant, boolean persistent) {
            this.unit = unit;
            this.properties = properties;
            this.instant = instant;
            this.persistent = persistent;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.unit()));
            n = Statics.mix(n, Statics.anyHash(this.properties()));
            n = Statics.mix(n, Statics.anyHash(this.instant()));
            n = Statics.mix(n, this.persistent() ? 1231 : 1237);
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ActiveTimer)) return false;
            ActiveTimer activeTimer = (ActiveTimer)object;
            if (this.persistent() != activeTimer.persistent()) return false;
            ListUnitsByPatternsStruct listUnitsByPatternsStruct = this.unit();
            ListUnitsByPatternsStruct listUnitsByPatternsStruct2 = activeTimer.unit();
            if (listUnitsByPatternsStruct == null) {
                if (listUnitsByPatternsStruct2 != null) {
                    return false;
                }
            } else if (!((Object)listUnitsByPatternsStruct).equals(listUnitsByPatternsStruct2)) return false;
            Map<String, Variant<?>> map = this.properties();
            Map<String, Variant<?>> map2 = activeTimer.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Instant instant = this.instant();
            Instant instant2 = activeTimer.instant();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            if (!activeTimer.canEqual(this)) return false;
            return true;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ActiveTimer;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "ActiveTimer";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean(this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "unit";
                }
                case 1: {
                    return "properties";
                }
                case 2: {
                    return "instant";
                }
                case 3: {
                    return "persistent";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ListUnitsByPatternsStruct unit() {
            return this.unit;
        }

        public Map<String, Variant<?>> properties() {
            return this.properties;
        }

        public Instant instant() {
            return this.instant;
        }

        public boolean persistent() {
            return this.persistent;
        }

        public OffsetDateTime localTime() {
            Object object = this.localTime$lzy1;
            if (object instanceof OffsetDateTime) {
                return (OffsetDateTime)object;
            }
            if (object == LazyVals$NullValue$.MODULE$) {
                return null;
            }
            return (OffsetDateTime)this.localTime$lzyINIT1();
        }

        private Object localTime$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.localTime$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                        Serializable serializable = null;
                        OffsetDateTime offsetDateTime = null;
                        try {
                            offsetDateTime = OffsetDateTime.ofInstant(this.instant(), ZoneId.systemDefault());
                            serializable = offsetDateTime == null ? LazyVals$NullValue$.MODULE$ : offsetDateTime;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.localTime$lzy1;
                                LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                                waiting.countDown();
                            }
                        }
                        return offsetDateTime;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals$Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public String toString() {
            return new StringBuilder(7).append(this.unit().getUnitName()).append(" - ").append(this.instant()).append(": p:").append(this.persistent()).toString();
        }

        public String toVerboseString() {
            return new StringBuilder(5).append(this.unit().getUnitName()).append(" - ").append(this.instant()).append(": ").append(this.properties()).toString();
        }

        public String toLocalTzString() {
            return new StringBuilder(3).append(this.unit().getUnitName()).append(" - ").append(this.localTime()).toString();
        }

        public ActiveTimer copy(ListUnitsByPatternsStruct unit, Map<String, Variant<?>> properties, Instant instant, boolean persistent) {
            return new ActiveTimer(unit, properties, instant, persistent);
        }

        public ListUnitsByPatternsStruct copy$default$1() {
            return this.unit();
        }

        public Map<String, Variant<?>> copy$default$2() {
            return this.properties();
        }

        public Instant copy$default$3() {
            return this.instant();
        }

        public boolean copy$default$4() {
            return this.persistent();
        }

        public ListUnitsByPatternsStruct _1() {
            return this.unit();
        }

        public Map<String, Variant<?>> _2() {
            return this.properties();
        }

        public Instant _3() {
            return this.instant();
        }

        public boolean _4() {
            return this.persistent();
        }
    }

    public static interface Interface {
        public int sd_notify(int var1, String var2);

        public int sd_watchdog_enabled(int var1, Pointer var2);
    }
}

