/*
 * Decompiled with CFR 0.152.
 */
package org.hampelratte.svdrp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hampelratte.svdrp.Command;
import org.hampelratte.svdrp.Response;
import org.hampelratte.svdrp.Version;
import org.hampelratte.svdrp.commands.PUTE;
import org.hampelratte.svdrp.commands.QUIT;
import org.hampelratte.svdrp.responses.AccessDenied;
import org.hampelratte.svdrp.responses.NotImplementedBySVDRP4J;
import org.hampelratte.svdrp.responses.PluginResponse;
import org.hampelratte.svdrp.responses.R214;
import org.hampelratte.svdrp.responses.R215;
import org.hampelratte.svdrp.responses.R216;
import org.hampelratte.svdrp.responses.R220;
import org.hampelratte.svdrp.responses.R221;
import org.hampelratte.svdrp.responses.R250;
import org.hampelratte.svdrp.responses.R354;
import org.hampelratte.svdrp.responses.R451;
import org.hampelratte.svdrp.responses.R500;
import org.hampelratte.svdrp.responses.R501;
import org.hampelratte.svdrp.responses.R502;
import org.hampelratte.svdrp.responses.R550;
import org.hampelratte.svdrp.responses.R554;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static transient Logger logger = LoggerFactory.getLogger(Connection.class);
    private final Socket socket;
    private BufferedWriter out;
    private BufferedReader in;
    private static Version version;
    private String encoding;

    public Connection(String host, int port, int connectTimeout) throws UnknownHostException, IOException {
        this(host, port, connectTimeout, "UTF-8");
    }

    public Connection(String host, int port, int connectTimeout, String encoding) throws UnknownHostException, IOException {
        this(host, port, connectTimeout, 0, "UTF-8", true);
    }

    public Connection(String host, int port, int connectTimeout, int readTimeout, String encoding, boolean detectEncoding) throws UnknownHostException, IOException {
        this.encoding = encoding;
        this.socket = new Socket();
        InetSocketAddress sa = new InetSocketAddress(host, port);
        this.socket.connect(sa, connectTimeout);
        this.socket.setSoTimeout(readTimeout);
        this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), encoding), 8192);
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), encoding), 8192);
        Response res = null;
        try {
            res = this.readResponse();
        }
        catch (IOException e1) {
            this.out.close();
            this.in.close();
            try {
                this.socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw e1;
        }
        if (res.getCode() == 220) {
            String msg = res.getMessage().trim();
            try {
                Pattern pattern = Pattern.compile(".*((?:\\d)+\\.(?:\\d)+\\.(?:\\d)+).*");
                Matcher m = pattern.matcher(msg);
                if (!m.matches()) {
                    throw new Exception("No Version String found in welcome message");
                }
                version = new Version(m.group(1));
            }
            catch (Exception e) {
                version = new Version("1.0.0");
            }
            if (detectEncoding) {
                try {
                    int lastSemicolon = msg.lastIndexOf(59);
                    if (lastSemicolon > 0) {
                        String lastSegment = msg.substring(lastSemicolon + 1).trim();
                        if (Charset.availableCharsets().containsKey(lastSegment)) {
                            logger.debug("VDR is running with charset {}", (Object)lastSegment);
                            this.encoding = lastSegment;
                            if (!this.encoding.equalsIgnoreCase(encoding)) {
                                logger.debug("Connection has been established with encoding {}. Now switching to {}", (Object)encoding, (Object)this.encoding);
                                this.out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), this.encoding), 8192);
                                this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), this.encoding), 8192);
                            }
                        }
                    }
                }
                catch (Exception e) {}
            }
        } else {
            throw new IOException(res.getMessage());
        }
    }

    public Connection(String host, int port) throws UnknownHostException, IOException {
        this(host, port, 500);
    }

    public synchronized Response send(Command cmd) throws IOException {
        if (cmd instanceof PUTE) {
            this.out.write("PUTE");
            this.out.newLine();
            this.out.flush();
            Response res = this.readResponse();
            if (res.getCode() != 354) {
                return res;
            }
        }
        this.out.write(cmd.getCommand());
        this.out.newLine();
        this.out.flush();
        logger.debug("--> {}", (Object)cmd.getCommand());
        Response response = this.readResponse();
        logger.debug("<-- {} {}", (Object)response.getCode(), (Object)response.getMessage());
        return response;
    }

    private Response readResponse() throws IOException {
        Response response = null;
        String line = "";
        StringBuilder msg = new StringBuilder();
        boolean running = true;
        while (running && (line = this.in.readLine()) != null) {
            if (line.length() < 4) continue;
            char fourthChar = line.charAt(3);
            int code = -1;
            try {
                code = Integer.parseInt(line.substring(0, 3));
                line = line.substring(4);
            }
            catch (Exception e) {
                code = -1;
            }
            if (fourthChar != '-') {
                running = false;
                msg.append(line);
                msg.append('\n');
                switch (code) {
                    case -1: {
                        response = new AccessDenied(line);
                        break;
                    }
                    case 214: {
                        response = new R214(msg.toString());
                        break;
                    }
                    case 215: {
                        response = new R215(msg.toString());
                        break;
                    }
                    case 216: {
                        response = new R216(msg.toString());
                        break;
                    }
                    case 220: {
                        response = new R220(msg.toString());
                        break;
                    }
                    case 221: {
                        response = new R221(msg.toString());
                        break;
                    }
                    case 250: {
                        response = new R250(msg.toString());
                        break;
                    }
                    case 354: {
                        response = new R354(msg.toString());
                        break;
                    }
                    case 451: {
                        response = new R451(msg.toString());
                        break;
                    }
                    case 500: {
                        response = new R500(msg.toString());
                        break;
                    }
                    case 501: {
                        response = new R501(msg.toString());
                        break;
                    }
                    case 502: {
                        response = new R502(msg.toString());
                        break;
                    }
                    case 550: {
                        response = new R550(msg.toString());
                        break;
                    }
                    case 554: {
                        response = new R554(msg.toString());
                        break;
                    }
                    default: {
                        response = code >= 900 && code <= 999 ? new PluginResponse(code, msg.toString()) : new NotImplementedBySVDRP4J(code, msg.toString());
                    }
                }
                line = "";
                msg = new StringBuilder();
                continue;
            }
            msg.append(line);
            msg.append("\n");
        }
        return response;
    }

    public void close() throws IOException {
        this.send(new QUIT());
        if (this.out != null) {
            this.out.close();
        }
        if (this.in != null) {
            this.in.close();
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public static Version getVersion() {
        return version;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

