// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceHTTPResponseRuleBackendOKCode is the HTTP code returned for type ReplaceHTTPResponseRuleBackendOK
const ReplaceHTTPResponseRuleBackendOKCode int = 200

/*
ReplaceHTTPResponseRuleBackendOK HTTP Response Rule replaced

swagger:response replaceHttpResponseRuleBackendOK
*/
type ReplaceHTTPResponseRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleBackendOK creates ReplaceHTTPResponseRuleBackendOK with default headers values
func NewReplaceHTTPResponseRuleBackendOK() *ReplaceHTTPResponseRuleBackendOK {

	return &ReplaceHTTPResponseRuleBackendOK{}
}

// WithPayload adds the payload to the replace Http response rule backend o k response
func (o *ReplaceHTTPResponseRuleBackendOK) WithPayload(payload *models.HTTPResponseRule) *ReplaceHTTPResponseRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule backend o k response
func (o *ReplaceHTTPResponseRuleBackendOK) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPResponseRuleBackendAcceptedCode is the HTTP code returned for type ReplaceHTTPResponseRuleBackendAccepted
const ReplaceHTTPResponseRuleBackendAcceptedCode int = 202

/*
ReplaceHTTPResponseRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceHttpResponseRuleBackendAccepted
*/
type ReplaceHTTPResponseRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPResponseRule `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleBackendAccepted creates ReplaceHTTPResponseRuleBackendAccepted with default headers values
func NewReplaceHTTPResponseRuleBackendAccepted() *ReplaceHTTPResponseRuleBackendAccepted {

	return &ReplaceHTTPResponseRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Http response rule backend accepted response
func (o *ReplaceHTTPResponseRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceHTTPResponseRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Http response rule backend accepted response
func (o *ReplaceHTTPResponseRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Http response rule backend accepted response
func (o *ReplaceHTTPResponseRuleBackendAccepted) WithPayload(payload *models.HTTPResponseRule) *ReplaceHTTPResponseRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule backend accepted response
func (o *ReplaceHTTPResponseRuleBackendAccepted) SetPayload(payload *models.HTTPResponseRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPResponseRuleBackendBadRequestCode is the HTTP code returned for type ReplaceHTTPResponseRuleBackendBadRequest
const ReplaceHTTPResponseRuleBackendBadRequestCode int = 400

/*
ReplaceHTTPResponseRuleBackendBadRequest Bad request

swagger:response replaceHttpResponseRuleBackendBadRequest
*/
type ReplaceHTTPResponseRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleBackendBadRequest creates ReplaceHTTPResponseRuleBackendBadRequest with default headers values
func NewReplaceHTTPResponseRuleBackendBadRequest() *ReplaceHTTPResponseRuleBackendBadRequest {

	return &ReplaceHTTPResponseRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http response rule backend bad request response
func (o *ReplaceHTTPResponseRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPResponseRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http response rule backend bad request response
func (o *ReplaceHTTPResponseRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http response rule backend bad request response
func (o *ReplaceHTTPResponseRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceHTTPResponseRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule backend bad request response
func (o *ReplaceHTTPResponseRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceHTTPResponseRuleBackendNotFoundCode is the HTTP code returned for type ReplaceHTTPResponseRuleBackendNotFound
const ReplaceHTTPResponseRuleBackendNotFoundCode int = 404

/*
ReplaceHTTPResponseRuleBackendNotFound The specified resource was not found

swagger:response replaceHttpResponseRuleBackendNotFound
*/
type ReplaceHTTPResponseRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleBackendNotFound creates ReplaceHTTPResponseRuleBackendNotFound with default headers values
func NewReplaceHTTPResponseRuleBackendNotFound() *ReplaceHTTPResponseRuleBackendNotFound {

	return &ReplaceHTTPResponseRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Http response rule backend not found response
func (o *ReplaceHTTPResponseRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPResponseRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Http response rule backend not found response
func (o *ReplaceHTTPResponseRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Http response rule backend not found response
func (o *ReplaceHTTPResponseRuleBackendNotFound) WithPayload(payload *models.Error) *ReplaceHTTPResponseRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Http response rule backend not found response
func (o *ReplaceHTTPResponseRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceHTTPResponseRuleBackendDefault General Error

swagger:response replaceHttpResponseRuleBackendDefault
*/
type ReplaceHTTPResponseRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceHTTPResponseRuleBackendDefault creates ReplaceHTTPResponseRuleBackendDefault with default headers values
func NewReplaceHTTPResponseRuleBackendDefault(code int) *ReplaceHTTPResponseRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceHTTPResponseRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace HTTP response rule backend default response
func (o *ReplaceHTTPResponseRuleBackendDefault) WithStatusCode(code int) *ReplaceHTTPResponseRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace HTTP response rule backend default response
func (o *ReplaceHTTPResponseRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace HTTP response rule backend default response
func (o *ReplaceHTTPResponseRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceHTTPResponseRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace HTTP response rule backend default response
func (o *ReplaceHTTPResponseRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace HTTP response rule backend default response
func (o *ReplaceHTTPResponseRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceHTTPResponseRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace HTTP response rule backend default response
func (o *ReplaceHTTPResponseRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceHTTPResponseRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
