INCLUDE(CMakeHelpers)


FIND_PACKAGE(OpenMP REQUIRED)
SET(CMAKE_Fortran_FLAGS "${CMAKE_Fortran_FLAGS} ${OpenMP_Fortran_FLAGS}" CACHE INTERNAL "")
SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${OpenMP_C_FLAGS}" CACHE INTERNAL "")
SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${OpenMP_CXX_FLAGS}" CACHE INTERNAL "")

MESSAGE_COLOR(STATUS COLOR_GREEN "C   OpenMP Support:     ${OpenMP_C_VERSION}")
MESSAGE_COLOR(STATUS COLOR_GREEN "C++ OpenMP Support:     ${OpenMP_CXX_VERSION}")
MESSAGE_COLOR(STATUS COLOR_GREEN "Fortran OpenMP Support: ${OpenMP_Fortran_VERSION}")
IF(OpenMP_Fortran_VERSION VERSION_LESS "4.0")
    MESSAGE_COLOR(STATUS COLOR_BOLD_RED "The Fortran Compiler does not support OpenMP 4.")
    SET(HAVE_OPENMP_4 FALSE)
ELSE()
    SET(HAVE_OPENMP_4 TRUE)
    ADD_DEFINITIONS(-DHAVE_OPENMP_4)
ENDIF()

