IF(CMAKE_C_COMPILER_LOADED)

INCLUDE(CheckCCompilerFlag)


FUNCTION(ADD_C_COMPILER_FLAG VAR FLAGNAME )
    IF(DEFINED CACHE{C_${VAR}_${FLAGNAME}_WORK})
        RETURN()
    ENDIF()
    SET(_SAVE ${CMAKE_REQUIRED_QUIET})
    UNSET(_WORKS CACHE)
    SET(CMAKE_REQUIRED_QUIET TRUE)
    CHECK_C_COMPILER_FLAG("${FLAGNAME}" _WORKS)
    SET(C_${VAR}_${FLAGNAME}_WORK ${_WORKS} CACHE INTERNAL "C Compiler supports ${FLAGNAME}")

    IF ( _WORKS)
        SET(${VAR} "${${VAR}} ${FLAGNAME}" CACHE INTERNAL "")
        MESSAGE(STATUS "C compiler supports ${FLAGNAME}")
    ELSE()
        MESSAGE(STATUS "C compiler does not support ${FLAGNAME}")
    ENDIF()
    SET(CMAKE_REQUIRED_QUIET ${_SAVE})
ENDFUNCTION()


IF(NOT "${HOSTOPT}" STREQUAL "")
    IF(NOT (HOSTOPT STREQUAL OFF OR HOSTOPT STREQUAL ON))
        STRING(SUBSTRING "${HOSTOPT}" 0 1 FIRST_CHAR)
        IF( "${FIRST_CHAR}" STREQUAL "/" )
            MESSAGE(STATUS "Load user supplied Host Optimizations for C -- ${HOSTOPT}")
            INCLUDE(${HOSTOPT})
        ELSE()
            MESSAGE(STATUS  "Load user supplied Host Optimizations for C -- ${CMAKE_BINARY_DIR}/${HOSTOPT}")
            INCLUDE(${CMAKE_BINARY_DIR}/${HOSTOPT})
        ENDIF()
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${HOSTOPT_C}")
    ENDIF()
ENDIF()


ADD_DEFINITIONS(-D_FILE_OFFSET_BITS=64)
IF(CMAKE_C_COMPILER_ID STREQUAL "GNU")
    # GNU
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-fPIC")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-O3")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wall")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wunused")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-g")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wextra")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wshadow")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wstrict-aliasing")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wundef")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wlogical-op")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wparentheses")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wcast-qual")

    IF(DEBUGOPT STREQUAL ON)
        ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-O3")
    ELSE()
        ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-O0")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()


    IF(HOSTOPT STREQUAL ON)
        IF (CMAKE_SYSTEM_PROCESSOR STREQUAL "ppc64le")
            ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-mcpu=native")
            ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-mtune=native")
        ELSE ()
            ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-march=native")
            ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-mtune=native")
        ENDIF()
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "Clang" )
    IF(CMAKE_C_COMPILER_FRONTEND_VARIANT STREQUAL "MSVC")
        # clang-cl
        # Note that there is no need for position independent code on Windows
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -D_CRT_SECURE_NO_WARNINGS -D_CRT_SECURE_NO_DEPRECATE")
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} /O2")
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /W4 /DEBUG")

        IF(DEBUGOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /O2")
        ELSE()
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /Od")
        ENDIF()

        IF(INTEGER8 STREQUAL ON)
            ADD_DEFINITIONS(-DINTEGER8)
        ENDIF()

        IF(HOSTOPT STREQUAL ON)
            IF(NOT CMAKE_C_COMPILER_VERSION VERSION_LESS 8)
                SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -march=native")
            ELSE()
                MESSAGE(WARNING "No automatic host optimization available for clang-cl 7 or earlier.")
            ENDIF()
        ENDIF()
    ELSEIF(CMAKE_C_COMPILER_FRONTEND_VARIANT STREQUAL "GNU")
        # clang
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fPIC")
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wall -Wunused -g -Wextra -Wshadow -Wstrict-aliasing")
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wundef -Wparentheses -Wcast-qual")

        IF(DEBUGOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O3")
        ELSE()
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0")
        ENDIF()

        IF(INTEGER8 STREQUAL ON)
            ADD_DEFINITIONS(-DINTEGER8)
        ENDIF()

        IF(HOSTOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -march=native -mtune=native")
        ENDIF()
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "MSVC")
    # MSVC
    # Note that there is no need for position independent code on Windows
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -D_CRT_SECURE_NO_WARNINGS -D_CRT_SECURE_NO_DEPRECATE")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} /O2")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /W4 /DEBUG")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /O2")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} /Od")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        MESSAGE(WARNING "No automatic host optimization available for MSVC C compiler.")
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "Intel")
    # Intel
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fpic")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wall -g")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O3")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -xHost")
    ENDIF()

ELSEIF (CMAKE_C_COMPILER_ID STREQUAL "IntelLLVM")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-fpic")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-O3")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-Wall")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-g")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-qopt-report=3")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-xCORE-AVX2")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-fvec-peel-loops")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-unroll")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-fma")
    ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_RELEASE "-finline-functions")


    IF(DEBUGOPT STREQUAL ON)
        ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-O3")
    ELSE()
        ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS_DEBUG "-O0")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-xHOST")
        ADD_C_COMPILER_FLAG(CMAKE_C_FLAGS "-Ofast")
    ENDIF()



ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "NVHPC")
    # Nvidia HPC SDK (nvc)
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fpic -Mnoipa --diag_suppress bad_pp_directive_keyword")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG}")


    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -gopt -O3")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -g -O0")
    ENDIF()

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -fast -tp=native")
        IF (DEBUGOPT STREQUAL ON)
            SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -fast -tp=native")
        ENDIF()
    ENDIF()

ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "XL")
    # IBM XLC
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -qpic -qmaxmem=32768")
    IF(HOSTOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O5 -qtune=auto -qarch=auto")
    ELSE()
        SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE} -O3")
    ENDIF()
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -Wall -g9")

    IF(DEBUGOPT STREQUAL ON)
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O2")
    ELSE()
        SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -O0")
    ENDIF()

    STRING(REPLACE "-qhalt=e" "" CMAKE_C_FLAGS "${CMAKE_C_FLAGS}")

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(OPENMP_FOUND)
        SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} ${OpenMP_C_FLAGS}")
        LIST(REMOVE_ITEM CMAKE_C_IMPLICIT_LINK_LIBRARIES "xlomp_ser")
    ENDIF()
ELSEIF(CMAKE_C_COMPILER_ID STREQUAL "TinyCC")
    # Tiny CC
    # Note that as of version 0.9.27 there is no support for optimization or position independent code generation
    SET(CMAKE_C_FLAGS "${CMAKE_C_FLAGS}")
    SET(CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE}")
    SET(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -g -Wall")

    IF(INTEGER8 STREQUAL ON)
        ADD_DEFINITIONS(-DINTEGER8)
    ENDIF()

    IF(HOSTOPT STREQUAL ON)
        MESSAGE(WARNING "No automatic host optimization available for Tiny C compiler.")
    ENDIF()
ENDIF()

ENDIF() # C Compiler loaded
