package yundun_dbaudit

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAlarmReceiveConfig invokes the yundun_dbaudit.DeleteAlarmReceiveConfig API synchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/deletealarmreceiveconfig.html
func (client *Client) DeleteAlarmReceiveConfig(request *DeleteAlarmReceiveConfigRequest) (response *DeleteAlarmReceiveConfigResponse, err error) {
	response = CreateDeleteAlarmReceiveConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAlarmReceiveConfigWithChan invokes the yundun_dbaudit.DeleteAlarmReceiveConfig API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/deletealarmreceiveconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlarmReceiveConfigWithChan(request *DeleteAlarmReceiveConfigRequest) (<-chan *DeleteAlarmReceiveConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteAlarmReceiveConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAlarmReceiveConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAlarmReceiveConfigWithCallback invokes the yundun_dbaudit.DeleteAlarmReceiveConfig API asynchronously
// api document: https://help.aliyun.com/api/yundun-dbaudit/deletealarmreceiveconfig.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlarmReceiveConfigWithCallback(request *DeleteAlarmReceiveConfigRequest, callback func(response *DeleteAlarmReceiveConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAlarmReceiveConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteAlarmReceiveConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAlarmReceiveConfigRequest is the request struct for api DeleteAlarmReceiveConfig
type DeleteAlarmReceiveConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
	ConfigId   string `position:"Query" name:"ConfigId"`
}

// DeleteAlarmReceiveConfigResponse is the response struct for api DeleteAlarmReceiveConfig
type DeleteAlarmReceiveConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAlarmReceiveConfigRequest creates a request to invoke DeleteAlarmReceiveConfig API
func CreateDeleteAlarmReceiveConfigRequest() (request *DeleteAlarmReceiveConfigRequest) {
	request = &DeleteAlarmReceiveConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-dbaudit", "2018-10-29", "DeleteAlarmReceiveConfig", "dbaudit", "openAPI")
	return
}

// CreateDeleteAlarmReceiveConfigResponse creates a response to parse from DeleteAlarmReceiveConfig response
func CreateDeleteAlarmReceiveConfigResponse() (response *DeleteAlarmReceiveConfigResponse) {
	response = &DeleteAlarmReceiveConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
