package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeStorage invokes the webplus.DescribeStorage API synchronously
// api document: https://help.aliyun.com/api/webplus/describestorage.html
func (client *Client) DescribeStorage(request *DescribeStorageRequest) (response *DescribeStorageResponse, err error) {
	response = CreateDescribeStorageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeStorageWithChan invokes the webplus.DescribeStorage API asynchronously
// api document: https://help.aliyun.com/api/webplus/describestorage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStorageWithChan(request *DescribeStorageRequest) (<-chan *DescribeStorageResponse, <-chan error) {
	responseChan := make(chan *DescribeStorageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeStorage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeStorageWithCallback invokes the webplus.DescribeStorage API asynchronously
// api document: https://help.aliyun.com/api/webplus/describestorage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeStorageWithCallback(request *DescribeStorageRequest, callback func(response *DescribeStorageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeStorageResponse
		var err error
		defer close(result)
		response, err = client.DescribeStorage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeStorageRequest is the request struct for api DescribeStorage
type DescribeStorageRequest struct {
	*requests.RoaRequest
}

// DescribeStorageResponse is the response struct for api DescribeStorage
type DescribeStorageResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	Storage   Storage `json:"Storage" xml:"Storage"`
}

// CreateDescribeStorageRequest creates a request to invoke DescribeStorage API
func CreateDescribeStorageRequest() (request *DescribeStorageRequest) {
	request = &DescribeStorageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeStorage", "/pop/v1/wam/storage", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeStorageResponse creates a response to parse from DescribeStorage response
func CreateDescribeStorageResponse() (response *DescribeStorageResponse) {
	response = &DescribeStorageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
