package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindParentPlatformDevice invokes the vs.UnbindParentPlatformDevice API synchronously
func (client *Client) UnbindParentPlatformDevice(request *UnbindParentPlatformDeviceRequest) (response *UnbindParentPlatformDeviceResponse, err error) {
	response = CreateUnbindParentPlatformDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindParentPlatformDeviceWithChan invokes the vs.UnbindParentPlatformDevice API asynchronously
func (client *Client) UnbindParentPlatformDeviceWithChan(request *UnbindParentPlatformDeviceRequest) (<-chan *UnbindParentPlatformDeviceResponse, <-chan error) {
	responseChan := make(chan *UnbindParentPlatformDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindParentPlatformDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindParentPlatformDeviceWithCallback invokes the vs.UnbindParentPlatformDevice API asynchronously
func (client *Client) UnbindParentPlatformDeviceWithCallback(request *UnbindParentPlatformDeviceRequest, callback func(response *UnbindParentPlatformDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindParentPlatformDeviceResponse
		var err error
		defer close(result)
		response, err = client.UnbindParentPlatformDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindParentPlatformDeviceRequest is the request struct for api UnbindParentPlatformDevice
type UnbindParentPlatformDeviceRequest struct {
	*requests.RpcRequest
	ParentPlatformId string           `position:"Query" name:"ParentPlatformId"`
	ShowLog          string           `position:"Query" name:"ShowLog"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	DeviceId         string           `position:"Query" name:"DeviceId"`
}

// UnbindParentPlatformDeviceResponse is the response struct for api UnbindParentPlatformDevice
type UnbindParentPlatformDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnbindParentPlatformDeviceRequest creates a request to invoke UnbindParentPlatformDevice API
func CreateUnbindParentPlatformDeviceRequest() (request *UnbindParentPlatformDeviceRequest) {
	request = &UnbindParentPlatformDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "UnbindParentPlatformDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindParentPlatformDeviceResponse creates a response to parse from UnbindParentPlatformDevice response
func CreateUnbindParentPlatformDeviceResponse() (response *UnbindParentPlatformDeviceResponse) {
	response = &UnbindParentPlatformDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
