package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateUserGroup invokes the vcs.UpdateUserGroup API synchronously
func (client *Client) UpdateUserGroup(request *UpdateUserGroupRequest) (response *UpdateUserGroupResponse, err error) {
	response = CreateUpdateUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateUserGroupWithChan invokes the vcs.UpdateUserGroup API asynchronously
func (client *Client) UpdateUserGroupWithChan(request *UpdateUserGroupRequest) (<-chan *UpdateUserGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateUserGroupWithCallback invokes the vcs.UpdateUserGroup API asynchronously
func (client *Client) UpdateUserGroupWithCallback(request *UpdateUserGroupRequest, callback func(response *UpdateUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateUserGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateUserGroupRequest is the request struct for api UpdateUserGroup
type UpdateUserGroupRequest struct {
	*requests.RpcRequest
	IsvSubId      string           `position:"Body" name:"IsvSubId"`
	CorpId        string           `position:"Body" name:"CorpId"`
	UserGroupId   requests.Integer `position:"Body" name:"UserGroupId"`
	UserGroupName string           `position:"Body" name:"UserGroupName"`
}

// UpdateUserGroupResponse is the response struct for api UpdateUserGroup
type UpdateUserGroupResponse struct {
	*responses.BaseResponse
	Code      string                `json:"Code" xml:"Code"`
	Message   string                `json:"Message" xml:"Message"`
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Data      DataInUpdateUserGroup `json:"Data" xml:"Data"`
}

// CreateUpdateUserGroupRequest creates a request to invoke UpdateUserGroup API
func CreateUpdateUserGroupRequest() (request *UpdateUserGroupRequest) {
	request = &UpdateUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "UpdateUserGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateUserGroupResponse creates a response to parse from UpdateUserGroup response
func CreateUpdateUserGroupResponse() (response *UpdateUserGroupResponse) {
	response = &UpdateUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
