package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTaskBizType invokes the unimkt.QueryTaskBizType API synchronously
func (client *Client) QueryTaskBizType(request *QueryTaskBizTypeRequest) (response *QueryTaskBizTypeResponse, err error) {
	response = CreateQueryTaskBizTypeResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTaskBizTypeWithChan invokes the unimkt.QueryTaskBizType API asynchronously
func (client *Client) QueryTaskBizTypeWithChan(request *QueryTaskBizTypeRequest) (<-chan *QueryTaskBizTypeResponse, <-chan error) {
	responseChan := make(chan *QueryTaskBizTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTaskBizType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTaskBizTypeWithCallback invokes the unimkt.QueryTaskBizType API asynchronously
func (client *Client) QueryTaskBizTypeWithCallback(request *QueryTaskBizTypeRequest, callback func(response *QueryTaskBizTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTaskBizTypeResponse
		var err error
		defer close(result)
		response, err = client.QueryTaskBizType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTaskBizTypeRequest is the request struct for api QueryTaskBizType
type QueryTaskBizTypeRequest struct {
	*requests.RpcRequest
	ChannelId string `position:"Query" name:"ChannelId"`
}

// QueryTaskBizTypeResponse is the response struct for api QueryTaskBizType
type QueryTaskBizTypeResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryTaskBizTypeRequest creates a request to invoke QueryTaskBizType API
func CreateQueryTaskBizTypeRequest() (request *QueryTaskBizTypeRequest) {
	request = &QueryTaskBizTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryTaskBizType", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryTaskBizTypeResponse creates a response to parse from QueryTaskBizType response
func CreateQueryTaskBizTypeResponse() (response *QueryTaskBizTypeResponse) {
	response = &QueryTaskBizTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
