package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PopUpQuery invokes the unimkt.PopUpQuery API synchronously
func (client *Client) PopUpQuery(request *PopUpQueryRequest) (response *PopUpQueryResponse, err error) {
	response = CreatePopUpQueryResponse()
	err = client.DoAction(request, response)
	return
}

// PopUpQueryWithChan invokes the unimkt.PopUpQuery API asynchronously
func (client *Client) PopUpQueryWithChan(request *PopUpQueryRequest) (<-chan *PopUpQueryResponse, <-chan error) {
	responseChan := make(chan *PopUpQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PopUpQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PopUpQueryWithCallback invokes the unimkt.PopUpQuery API asynchronously
func (client *Client) PopUpQueryWithCallback(request *PopUpQueryRequest, callback func(response *PopUpQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PopUpQueryResponse
		var err error
		defer close(result)
		response, err = client.PopUpQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PopUpQueryRequest is the request struct for api PopUpQuery
type PopUpQueryRequest struct {
	*requests.RpcRequest
	OptionType   string `position:"Body" name:"OptionType"`
	Extra        string `position:"Body" name:"Extra"`
	UrlId        string `position:"Body" name:"UrlId"`
	AlipayOpenId string `position:"Body" name:"AlipayOpenId"`
	ChannelId    string `position:"Body" name:"ChannelId"`
	OuterCode    string `position:"Body" name:"OuterCode"`
}

// PopUpQueryResponse is the response struct for api PopUpQuery
type PopUpQueryResponse struct {
	*responses.BaseResponse
	Status      bool   `json:"Status" xml:"Status"`
	Msg         string `json:"Msg" xml:"Msg"`
	ErrorCode   string `json:"ErrorCode" xml:"ErrorCode"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Url         string `json:"Url" xml:"Url"`
	UnionAmount string `json:"UnionAmount" xml:"UnionAmount"`
}

// CreatePopUpQueryRequest creates a request to invoke PopUpQuery API
func CreatePopUpQueryRequest() (request *PopUpQueryRequest) {
	request = &PopUpQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-07", "PopUpQuery", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePopUpQueryResponse creates a response to parse from PopUpQuery response
func CreatePopUpQueryResponse() (response *PopUpQueryResponse) {
	response = &PopUpQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
