package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewaysTags invokes the sgw.DescribeGatewaysTags API synchronously
func (client *Client) DescribeGatewaysTags(request *DescribeGatewaysTagsRequest) (response *DescribeGatewaysTagsResponse, err error) {
	response = CreateDescribeGatewaysTagsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewaysTagsWithChan invokes the sgw.DescribeGatewaysTags API asynchronously
func (client *Client) DescribeGatewaysTagsWithChan(request *DescribeGatewaysTagsRequest) (<-chan *DescribeGatewaysTagsResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewaysTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewaysTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewaysTagsWithCallback invokes the sgw.DescribeGatewaysTags API asynchronously
func (client *Client) DescribeGatewaysTagsWithCallback(request *DescribeGatewaysTagsRequest, callback func(response *DescribeGatewaysTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewaysTagsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewaysTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewaysTagsRequest is the request struct for api DescribeGatewaysTags
type DescribeGatewaysTagsRequest struct {
	*requests.RpcRequest
	GatewayIds      string `position:"Query" name:"GatewayIds"`
	SecurityToken   string `position:"Query" name:"SecurityToken"`
	TagCategory     string `position:"Query" name:"TagCategory"`
	StorageBundleId string `position:"Query" name:"StorageBundleId"`
}

// DescribeGatewaysTagsResponse is the response struct for api DescribeGatewaysTags
type DescribeGatewaysTagsResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	Success     bool        `json:"Success" xml:"Success"`
	Code        string      `json:"Code" xml:"Code"`
	Message     string      `json:"Message" xml:"Message"`
	GatewayTags GatewayTags `json:"GatewayTags" xml:"GatewayTags"`
}

// CreateDescribeGatewaysTagsRequest creates a request to invoke DescribeGatewaysTags API
func CreateDescribeGatewaysTagsRequest() (request *DescribeGatewaysTagsRequest) {
	request = &DescribeGatewaysTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewaysTags", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewaysTagsResponse creates a response to parse from DescribeGatewaysTags response
func CreateDescribeGatewaysTagsResponse() (response *DescribeGatewaysTagsResponse) {
	response = &DescribeGatewaysTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
