package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayAuthInfo invokes the sgw.DescribeGatewayAuthInfo API synchronously
func (client *Client) DescribeGatewayAuthInfo(request *DescribeGatewayAuthInfoRequest) (response *DescribeGatewayAuthInfoResponse, err error) {
	response = CreateDescribeGatewayAuthInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayAuthInfoWithChan invokes the sgw.DescribeGatewayAuthInfo API asynchronously
func (client *Client) DescribeGatewayAuthInfoWithChan(request *DescribeGatewayAuthInfoRequest) (<-chan *DescribeGatewayAuthInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayAuthInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayAuthInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayAuthInfoWithCallback invokes the sgw.DescribeGatewayAuthInfo API asynchronously
func (client *Client) DescribeGatewayAuthInfoWithCallback(request *DescribeGatewayAuthInfoRequest, callback func(response *DescribeGatewayAuthInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayAuthInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayAuthInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayAuthInfoRequest is the request struct for api DescribeGatewayAuthInfo
type DescribeGatewayAuthInfoRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayAuthInfoResponse is the response struct for api DescribeGatewayAuthInfo
type DescribeGatewayAuthInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	PublicIp  string `json:"PublicIp" xml:"PublicIp"`
	Username  string `json:"Username" xml:"Username"`
	Password  string `json:"Password" xml:"Password"`
}

// CreateDescribeGatewayAuthInfoRequest creates a request to invoke DescribeGatewayAuthInfo API
func CreateDescribeGatewayAuthInfoRequest() (request *DescribeGatewayAuthInfoRequest) {
	request = &DescribeGatewayAuthInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayAuthInfo", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayAuthInfoResponse creates a response to parse from DescribeGatewayAuthInfo response
func CreateDescribeGatewayAuthInfoResponse() (response *DescribeGatewayAuthInfoResponse) {
	response = &DescribeGatewayAuthInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
