package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAntiBruteForceRule invokes the sas.CreateAntiBruteForceRule API synchronously
func (client *Client) CreateAntiBruteForceRule(request *CreateAntiBruteForceRuleRequest) (response *CreateAntiBruteForceRuleResponse, err error) {
	response = CreateCreateAntiBruteForceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAntiBruteForceRuleWithChan invokes the sas.CreateAntiBruteForceRule API asynchronously
func (client *Client) CreateAntiBruteForceRuleWithChan(request *CreateAntiBruteForceRuleRequest) (<-chan *CreateAntiBruteForceRuleResponse, <-chan error) {
	responseChan := make(chan *CreateAntiBruteForceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAntiBruteForceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAntiBruteForceRuleWithCallback invokes the sas.CreateAntiBruteForceRule API asynchronously
func (client *Client) CreateAntiBruteForceRuleWithCallback(request *CreateAntiBruteForceRuleRequest, callback func(response *CreateAntiBruteForceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAntiBruteForceRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateAntiBruteForceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAntiBruteForceRuleRequest is the request struct for api CreateAntiBruteForceRule
type CreateAntiBruteForceRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ForbiddenTime   requests.Integer `position:"Query" name:"ForbiddenTime"`
	FailCount       requests.Integer `position:"Query" name:"FailCount"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	EnableSmartRule requests.Boolean `position:"Query" name:"EnableSmartRule"`
	UuidList        *[]string        `position:"Query" name:"UuidList"  type:"Repeated"`
	Name            string           `position:"Query" name:"Name"`
	Span            requests.Integer `position:"Query" name:"Span"`
	DefaultRule     requests.Boolean `position:"Query" name:"DefaultRule"`
}

// CreateAntiBruteForceRuleResponse is the response struct for api CreateAntiBruteForceRule
type CreateAntiBruteForceRuleResponse struct {
	*responses.BaseResponse
	RequestId                string                   `json:"RequestId" xml:"RequestId"`
	CreateAntiBruteForceRule CreateAntiBruteForceRule `json:"CreateAntiBruteForceRule" xml:"CreateAntiBruteForceRule"`
}

// CreateCreateAntiBruteForceRuleRequest creates a request to invoke CreateAntiBruteForceRule API
func CreateCreateAntiBruteForceRuleRequest() (request *CreateAntiBruteForceRuleRequest) {
	request = &CreateAntiBruteForceRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "CreateAntiBruteForceRule", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateAntiBruteForceRuleResponse creates a response to parse from CreateAntiBruteForceRule response
func CreateCreateAntiBruteForceRuleResponse() (response *CreateAntiBruteForceRuleResponse) {
	response = &CreateAntiBruteForceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
