package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEventSubscribe invokes the rtc.CreateEventSubscribe API synchronously
func (client *Client) CreateEventSubscribe(request *CreateEventSubscribeRequest) (response *CreateEventSubscribeResponse, err error) {
	response = CreateCreateEventSubscribeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEventSubscribeWithChan invokes the rtc.CreateEventSubscribe API asynchronously
func (client *Client) CreateEventSubscribeWithChan(request *CreateEventSubscribeRequest) (<-chan *CreateEventSubscribeResponse, <-chan error) {
	responseChan := make(chan *CreateEventSubscribeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEventSubscribe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEventSubscribeWithCallback invokes the rtc.CreateEventSubscribe API asynchronously
func (client *Client) CreateEventSubscribeWithCallback(request *CreateEventSubscribeRequest, callback func(response *CreateEventSubscribeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEventSubscribeResponse
		var err error
		defer close(result)
		response, err = client.CreateEventSubscribe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEventSubscribeRequest is the request struct for api CreateEventSubscribe
type CreateEventSubscribeRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Query" name:"ClientToken"`
	NeedCallbackAuth requests.Boolean `position:"Query" name:"NeedCallbackAuth"`
	Events           *[]string        `position:"Query" name:"Events"  type:"Repeated"`
	ShowLog          string           `position:"Query" name:"ShowLog"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	Users            *[]string        `position:"Query" name:"Users"  type:"Repeated"`
	AppId            string           `position:"Query" name:"AppId"`
	CallbackUrl      string           `position:"Query" name:"CallbackUrl"`
	ChannelId        string           `position:"Query" name:"ChannelId"`
}

// CreateEventSubscribeResponse is the response struct for api CreateEventSubscribe
type CreateEventSubscribeResponse struct {
	*responses.BaseResponse
	SubscribeId string `json:"SubscribeId" xml:"SubscribeId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateEventSubscribeRequest creates a request to invoke CreateEventSubscribe API
func CreateCreateEventSubscribeRequest() (request *CreateEventSubscribeRequest) {
	request = &CreateEventSubscribeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "CreateEventSubscribe", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateEventSubscribeResponse creates a response to parse from CreateEventSubscribe response
func CreateCreateEventSubscribeResponse() (response *CreateEventSubscribeResponse) {
	response = &CreateEventSubscribeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
