package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AllocateDirectConnection invokes the r_kvstore.AllocateDirectConnection API synchronously
func (client *Client) AllocateDirectConnection(request *AllocateDirectConnectionRequest) (response *AllocateDirectConnectionResponse, err error) {
	response = CreateAllocateDirectConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// AllocateDirectConnectionWithChan invokes the r_kvstore.AllocateDirectConnection API asynchronously
func (client *Client) AllocateDirectConnectionWithChan(request *AllocateDirectConnectionRequest) (<-chan *AllocateDirectConnectionResponse, <-chan error) {
	responseChan := make(chan *AllocateDirectConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AllocateDirectConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AllocateDirectConnectionWithCallback invokes the r_kvstore.AllocateDirectConnection API asynchronously
func (client *Client) AllocateDirectConnectionWithCallback(request *AllocateDirectConnectionRequest, callback func(response *AllocateDirectConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AllocateDirectConnectionResponse
		var err error
		defer close(result)
		response, err = client.AllocateDirectConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AllocateDirectConnectionRequest is the request struct for api AllocateDirectConnection
type AllocateDirectConnectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ConnectionString     string           `position:"Query" name:"ConnectionString"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	OnlyAllocateIp       requests.Boolean `position:"Query" name:"OnlyAllocateIp"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Port                 string           `position:"Query" name:"Port"`
}

// AllocateDirectConnectionResponse is the response struct for api AllocateDirectConnection
type AllocateDirectConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAllocateDirectConnectionRequest creates a request to invoke AllocateDirectConnection API
func CreateAllocateDirectConnectionRequest() (request *AllocateDirectConnectionRequest) {
	request = &AllocateDirectConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "AllocateDirectConnection", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAllocateDirectConnectionResponse creates a response to parse from AllocateDirectConnection response
func CreateAllocateDirectConnectionResponse() (response *AllocateDirectConnectionResponse) {
	response = &AllocateDirectConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
