package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DisableVpcEndpointZoneConnection invokes the privatelink.DisableVpcEndpointZoneConnection API synchronously
func (client *Client) DisableVpcEndpointZoneConnection(request *DisableVpcEndpointZoneConnectionRequest) (response *DisableVpcEndpointZoneConnectionResponse, err error) {
	response = CreateDisableVpcEndpointZoneConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// DisableVpcEndpointZoneConnectionWithChan invokes the privatelink.DisableVpcEndpointZoneConnection API asynchronously
func (client *Client) DisableVpcEndpointZoneConnectionWithChan(request *DisableVpcEndpointZoneConnectionRequest) (<-chan *DisableVpcEndpointZoneConnectionResponse, <-chan error) {
	responseChan := make(chan *DisableVpcEndpointZoneConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DisableVpcEndpointZoneConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DisableVpcEndpointZoneConnectionWithCallback invokes the privatelink.DisableVpcEndpointZoneConnection API asynchronously
func (client *Client) DisableVpcEndpointZoneConnectionWithCallback(request *DisableVpcEndpointZoneConnectionRequest, callback func(response *DisableVpcEndpointZoneConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DisableVpcEndpointZoneConnectionResponse
		var err error
		defer close(result)
		response, err = client.DisableVpcEndpointZoneConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DisableVpcEndpointZoneConnectionRequest is the request struct for api DisableVpcEndpointZoneConnection
type DisableVpcEndpointZoneConnectionRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Query" name:"ClientToken"`
	EndpointId       string           `position:"Query" name:"EndpointId"`
	ReplacedResource requests.Boolean `position:"Query" name:"ReplacedResource"`
	DryRun           requests.Boolean `position:"Query" name:"DryRun"`
	ZoneId           string           `position:"Query" name:"ZoneId"`
	ServiceId        string           `position:"Query" name:"ServiceId"`
}

// DisableVpcEndpointZoneConnectionResponse is the response struct for api DisableVpcEndpointZoneConnection
type DisableVpcEndpointZoneConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDisableVpcEndpointZoneConnectionRequest creates a request to invoke DisableVpcEndpointZoneConnection API
func CreateDisableVpcEndpointZoneConnectionRequest() (request *DisableVpcEndpointZoneConnectionRequest) {
	request = &DisableVpcEndpointZoneConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "DisableVpcEndpointZoneConnection", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDisableVpcEndpointZoneConnectionResponse creates a response to parse from DisableVpcEndpointZoneConnection response
func CreateDisableVpcEndpointZoneConnectionResponse() (response *DisableVpcEndpointZoneConnectionResponse) {
	response = &DisableVpcEndpointZoneConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
