package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteContactWhiteList invokes the outboundbot.DeleteContactWhiteList API synchronously
func (client *Client) DeleteContactWhiteList(request *DeleteContactWhiteListRequest) (response *DeleteContactWhiteListResponse, err error) {
	response = CreateDeleteContactWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteContactWhiteListWithChan invokes the outboundbot.DeleteContactWhiteList API asynchronously
func (client *Client) DeleteContactWhiteListWithChan(request *DeleteContactWhiteListRequest) (<-chan *DeleteContactWhiteListResponse, <-chan error) {
	responseChan := make(chan *DeleteContactWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteContactWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteContactWhiteListWithCallback invokes the outboundbot.DeleteContactWhiteList API asynchronously
func (client *Client) DeleteContactWhiteListWithCallback(request *DeleteContactWhiteListRequest, callback func(response *DeleteContactWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteContactWhiteListResponse
		var err error
		defer close(result)
		response, err = client.DeleteContactWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteContactWhiteListRequest is the request struct for api DeleteContactWhiteList
type DeleteContactWhiteListRequest struct {
	*requests.RpcRequest
	Operator           string `position:"Query" name:"Operator"`
	InstanceId         string `position:"Query" name:"InstanceId"`
	ContactWhiteListId string `position:"Query" name:"ContactWhiteListId"`
}

// DeleteContactWhiteListResponse is the response struct for api DeleteContactWhiteList
type DeleteContactWhiteListResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	AffectedRows   int    `json:"AffectedRows" xml:"AffectedRows"`
}

// CreateDeleteContactWhiteListRequest creates a request to invoke DeleteContactWhiteList API
func CreateDeleteContactWhiteListRequest() (request *DeleteContactWhiteListRequest) {
	request = &DeleteContactWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DeleteContactWhiteList", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteContactWhiteListResponse creates a response to parse from DeleteContactWhiteList response
func CreateDeleteContactWhiteListResponse() (response *DeleteContactWhiteListResponse) {
	response = &DeleteContactWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
