package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRolesByOwner invokes the oam.ListRolesByOwner API synchronously
// api document: https://help.aliyun.com/api/oam/listrolesbyowner.html
func (client *Client) ListRolesByOwner(request *ListRolesByOwnerRequest) (response *ListRolesByOwnerResponse, err error) {
	response = CreateListRolesByOwnerResponse()
	err = client.DoAction(request, response)
	return
}

// ListRolesByOwnerWithChan invokes the oam.ListRolesByOwner API asynchronously
// api document: https://help.aliyun.com/api/oam/listrolesbyowner.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRolesByOwnerWithChan(request *ListRolesByOwnerRequest) (<-chan *ListRolesByOwnerResponse, <-chan error) {
	responseChan := make(chan *ListRolesByOwnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRolesByOwner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRolesByOwnerWithCallback invokes the oam.ListRolesByOwner API asynchronously
// api document: https://help.aliyun.com/api/oam/listrolesbyowner.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRolesByOwnerWithCallback(request *ListRolesByOwnerRequest, callback func(response *ListRolesByOwnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRolesByOwnerResponse
		var err error
		defer close(result)
		response, err = client.ListRolesByOwner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRolesByOwnerRequest is the request struct for api ListRolesByOwner
type ListRolesByOwnerRequest struct {
	*requests.RpcRequest
	RoleNameHas   string           `position:"Query" name:"RoleNameHas"`
	RoleOwnerName string           `position:"Query" name:"RoleOwnerName"`
	RoleOwnerType string           `position:"Query" name:"RoleOwnerType"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	PageIndex     requests.Integer `position:"Query" name:"PageIndex"`
}

// ListRolesByOwnerResponse is the response struct for api ListRolesByOwner
type ListRolesByOwnerResponse struct {
	*responses.BaseResponse
	Code     string                 `json:"Code" xml:"Code"`
	Message  string                 `json:"Message" xml:"Message"`
	PageInfo PageInfo               `json:"PageInfo" xml:"PageInfo"`
	Data     DataInListRolesByOwner `json:"Data" xml:"Data"`
}

// CreateListRolesByOwnerRequest creates a request to invoke ListRolesByOwner API
func CreateListRolesByOwnerRequest() (request *ListRolesByOwnerRequest) {
	request = &ListRolesByOwnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "ListRolesByOwner", "", "")
	request.Method = requests.POST
	return
}

// CreateListRolesByOwnerResponse creates a response to parse from ListRolesByOwner response
func CreateListRolesByOwnerResponse() (response *ListRolesByOwnerResponse) {
	response = &ListRolesByOwnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
