package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOamUserByUserName invokes the oam.GetOamUserByUserName API synchronously
// api document: https://help.aliyun.com/api/oam/getoamuserbyusername.html
func (client *Client) GetOamUserByUserName(request *GetOamUserByUserNameRequest) (response *GetOamUserByUserNameResponse, err error) {
	response = CreateGetOamUserByUserNameResponse()
	err = client.DoAction(request, response)
	return
}

// GetOamUserByUserNameWithChan invokes the oam.GetOamUserByUserName API asynchronously
// api document: https://help.aliyun.com/api/oam/getoamuserbyusername.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOamUserByUserNameWithChan(request *GetOamUserByUserNameRequest) (<-chan *GetOamUserByUserNameResponse, <-chan error) {
	responseChan := make(chan *GetOamUserByUserNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOamUserByUserName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOamUserByUserNameWithCallback invokes the oam.GetOamUserByUserName API asynchronously
// api document: https://help.aliyun.com/api/oam/getoamuserbyusername.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOamUserByUserNameWithCallback(request *GetOamUserByUserNameRequest, callback func(response *GetOamUserByUserNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOamUserByUserNameResponse
		var err error
		defer close(result)
		response, err = client.GetOamUserByUserName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOamUserByUserNameRequest is the request struct for api GetOamUserByUserName
type GetOamUserByUserNameRequest struct {
	*requests.RpcRequest
	UserName string `position:"Query" name:"UserName"`
}

// GetOamUserByUserNameResponse is the response struct for api GetOamUserByUserName
type GetOamUserByUserNameResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
	Data    Data   `json:"Data" xml:"Data"`
}

// CreateGetOamUserByUserNameRequest creates a request to invoke GetOamUserByUserName API
func CreateGetOamUserByUserNameRequest() (request *GetOamUserByUserNameRequest) {
	request = &GetOamUserByUserNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "GetOamUserByUserName", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOamUserByUserNameResponse creates a response to parse from GetOamUserByUserName response
func CreateGetOamUserByUserNameResponse() (response *GetOamUserByUserNameResponse) {
	response = &GetOamUserByUserNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
