package nlp_automl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataset invokes the nlp_automl.ListDataset API synchronously
func (client *Client) ListDataset(request *ListDatasetRequest) (response *ListDatasetResponse, err error) {
	response = CreateListDatasetResponse()
	err = client.DoAction(request, response)
	return
}

// ListDatasetWithChan invokes the nlp_automl.ListDataset API asynchronously
func (client *Client) ListDatasetWithChan(request *ListDatasetRequest) (<-chan *ListDatasetResponse, <-chan error) {
	responseChan := make(chan *ListDatasetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataset(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDatasetWithCallback invokes the nlp_automl.ListDataset API asynchronously
func (client *Client) ListDatasetWithCallback(request *ListDatasetRequest, callback func(response *ListDatasetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDatasetResponse
		var err error
		defer close(result)
		response, err = client.ListDataset(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDatasetRequest is the request struct for api ListDataset
type ListDatasetRequest struct {
	*requests.RpcRequest
	Product    string           `position:"Body" name:"Product"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	ProjectId  requests.Integer `position:"Body" name:"ProjectId"`
}

// ListDatasetResponse is the response struct for api ListDataset
type ListDatasetResponse struct {
	*responses.BaseResponse
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Data      map[string]interface{} `json:"Data" xml:"Data"`
	Code      int                    `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	Success   bool                   `json:"Success" xml:"Success"`
}

// CreateListDatasetRequest creates a request to invoke ListDataset API
func CreateListDatasetRequest() (request *ListDatasetRequest) {
	request = &ListDatasetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nlp-automl", "2019-11-11", "ListDataset", "nlpautoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDatasetResponse creates a response to parse from ListDataset response
func CreateListDatasetResponse() (response *ListDatasetResponse) {
	response = &ListDatasetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
