package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitSubtitleJob invokes the mts.SubmitSubtitleJob API synchronously
func (client *Client) SubmitSubtitleJob(request *SubmitSubtitleJobRequest) (response *SubmitSubtitleJobResponse, err error) {
	response = CreateSubmitSubtitleJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitSubtitleJobWithChan invokes the mts.SubmitSubtitleJob API asynchronously
func (client *Client) SubmitSubtitleJobWithChan(request *SubmitSubtitleJobRequest) (<-chan *SubmitSubtitleJobResponse, <-chan error) {
	responseChan := make(chan *SubmitSubtitleJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitSubtitleJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitSubtitleJobWithCallback invokes the mts.SubmitSubtitleJob API asynchronously
func (client *Client) SubmitSubtitleJobWithCallback(request *SubmitSubtitleJobRequest, callback func(response *SubmitSubtitleJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitSubtitleJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitSubtitleJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitSubtitleJobRequest is the request struct for api SubmitSubtitleJob
type SubmitSubtitleJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	OutputConfig         string           `position:"Query" name:"OutputConfig"`
	InputConfig          string           `position:"Query" name:"InputConfig"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
}

// SubmitSubtitleJobResponse is the response struct for api SubmitSubtitleJob
type SubmitSubtitleJobResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	SubtitleJob SubtitleJob `json:"SubtitleJob" xml:"SubtitleJob"`
}

// CreateSubmitSubtitleJobRequest creates a request to invoke SubmitSubtitleJob API
func CreateSubmitSubtitleJobRequest() (request *SubmitSubtitleJobRequest) {
	request = &SubmitSubtitleJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitSubtitleJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitSubtitleJobResponse creates a response to parse from SubmitSubtitleJob response
func CreateSubmitSubtitleJobResponse() (response *SubmitSubtitleJobResponse) {
	response = &SubmitSubtitleJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
