package mopen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MoPenQueryCanvas invokes the mopen.MoPenQueryCanvas API synchronously
// api document: https://help.aliyun.com/api/mopen/mopenquerycanvas.html
func (client *Client) MoPenQueryCanvas(request *MoPenQueryCanvasRequest) (response *MoPenQueryCanvasResponse, err error) {
	response = CreateMoPenQueryCanvasResponse()
	err = client.DoAction(request, response)
	return
}

// MoPenQueryCanvasWithChan invokes the mopen.MoPenQueryCanvas API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenquerycanvas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenQueryCanvasWithChan(request *MoPenQueryCanvasRequest) (<-chan *MoPenQueryCanvasResponse, <-chan error) {
	responseChan := make(chan *MoPenQueryCanvasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MoPenQueryCanvas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MoPenQueryCanvasWithCallback invokes the mopen.MoPenQueryCanvas API asynchronously
// api document: https://help.aliyun.com/api/mopen/mopenquerycanvas.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MoPenQueryCanvasWithCallback(request *MoPenQueryCanvasRequest, callback func(response *MoPenQueryCanvasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MoPenQueryCanvasResponse
		var err error
		defer close(result)
		response, err = client.MoPenQueryCanvas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MoPenQueryCanvasRequest is the request struct for api MoPenQueryCanvas
type MoPenQueryCanvasRequest struct {
	*requests.RpcRequest
	DeviceName string           `position:"Body" name:"DeviceName"`
	SessionId  string           `position:"Body" name:"SessionId"`
	PageId     requests.Integer `position:"Body" name:"PageId"`
	Status     requests.Integer `position:"Body" name:"Status"`
}

// MoPenQueryCanvasResponse is the response struct for api MoPenQueryCanvas
type MoPenQueryCanvasResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Code        string `json:"Code" xml:"Code"`
	Message     string `json:"Message" xml:"Message"`
	Success     bool   `json:"Success" xml:"Success"`
	Description string `json:"Description" xml:"Description"`
	Data        Data   `json:"Data" xml:"Data"`
}

// CreateMoPenQueryCanvasRequest creates a request to invoke MoPenQueryCanvas API
func CreateMoPenQueryCanvasRequest() (request *MoPenQueryCanvasRequest) {
	request = &MoPenQueryCanvasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("MoPen", "2018-02-11", "MoPenQueryCanvas", "mopen", "openAPI")
	return
}

// CreateMoPenQueryCanvasResponse creates a response to parse from MoPenQueryCanvas response
func CreateMoPenQueryCanvasResponse() (response *MoPenQueryCanvasResponse) {
	response = &MoPenQueryCanvasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
