package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveIpInfo invokes the live.DescribeLiveIpInfo API synchronously
func (client *Client) DescribeLiveIpInfo(request *DescribeLiveIpInfoRequest) (response *DescribeLiveIpInfoResponse, err error) {
	response = CreateDescribeLiveIpInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveIpInfoWithChan invokes the live.DescribeLiveIpInfo API asynchronously
func (client *Client) DescribeLiveIpInfoWithChan(request *DescribeLiveIpInfoRequest) (<-chan *DescribeLiveIpInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveIpInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveIpInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveIpInfoWithCallback invokes the live.DescribeLiveIpInfo API asynchronously
func (client *Client) DescribeLiveIpInfoWithCallback(request *DescribeLiveIpInfoRequest, callback func(response *DescribeLiveIpInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveIpInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveIpInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveIpInfoRequest is the request struct for api DescribeLiveIpInfo
type DescribeLiveIpInfoRequest struct {
	*requests.RpcRequest
	Method  string           `position:"Query" name:"Method"`
	IP      string           `position:"Query" name:"IP"`
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveIpInfoResponse is the response struct for api DescribeLiveIpInfo
type DescribeLiveIpInfoResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	ISP         string `json:"ISP" xml:"ISP"`
	IspEname    string `json:"IspEname" xml:"IspEname"`
	Region      string `json:"Region" xml:"Region"`
	RegionEname string `json:"RegionEname" xml:"RegionEname"`
}

// CreateDescribeLiveIpInfoRequest creates a request to invoke DescribeLiveIpInfo API
func CreateDescribeLiveIpInfoRequest() (request *DescribeLiveIpInfoRequest) {
	request = &DescribeLiveIpInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveIpInfo", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveIpInfoResponse creates a response to parse from DescribeLiveIpInfo response
func CreateDescribeLiveIpInfoResponse() (response *DescribeLiveIpInfoResponse) {
	response = &DescribeLiveIpInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
