package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNodeGroupsPacketStat invokes the linkwan.ListNodeGroupsPacketStat API synchronously
func (client *Client) ListNodeGroupsPacketStat(request *ListNodeGroupsPacketStatRequest) (response *ListNodeGroupsPacketStatResponse, err error) {
	response = CreateListNodeGroupsPacketStatResponse()
	err = client.DoAction(request, response)
	return
}

// ListNodeGroupsPacketStatWithChan invokes the linkwan.ListNodeGroupsPacketStat API asynchronously
func (client *Client) ListNodeGroupsPacketStatWithChan(request *ListNodeGroupsPacketStatRequest) (<-chan *ListNodeGroupsPacketStatResponse, <-chan error) {
	responseChan := make(chan *ListNodeGroupsPacketStatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNodeGroupsPacketStat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNodeGroupsPacketStatWithCallback invokes the linkwan.ListNodeGroupsPacketStat API asynchronously
func (client *Client) ListNodeGroupsPacketStatWithCallback(request *ListNodeGroupsPacketStatRequest, callback func(response *ListNodeGroupsPacketStatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNodeGroupsPacketStatResponse
		var err error
		defer close(result)
		response, err = client.ListNodeGroupsPacketStat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNodeGroupsPacketStatRequest is the request struct for api ListNodeGroupsPacketStat
type ListNodeGroupsPacketStatRequest struct {
	*requests.RpcRequest
	EndMillis       requests.Integer `position:"Query" name:"EndMillis"`
	IotInstanceId   string           `position:"Query" name:"IotInstanceId"`
	NodeGroupIdList *[]string        `position:"Query" name:"NodeGroupIdList"  type:"Repeated"`
	ApiProduct      string           `position:"Body" name:"ApiProduct"`
	ApiRevision     string           `position:"Body" name:"ApiRevision"`
	BeginMillis     requests.Integer `position:"Query" name:"BeginMillis"`
}

// ListNodeGroupsPacketStatResponse is the response struct for api ListNodeGroupsPacketStat
type ListNodeGroupsPacketStatResponse struct {
	*responses.BaseResponse
	RequestId string                `json:"RequestId" xml:"RequestId"`
	Success   bool                  `json:"Success" xml:"Success"`
	Data      []NodeGroupPacketStat `json:"Data" xml:"Data"`
}

// CreateListNodeGroupsPacketStatRequest creates a request to invoke ListNodeGroupsPacketStat API
func CreateListNodeGroupsPacketStatRequest() (request *ListNodeGroupsPacketStatRequest) {
	request = &ListNodeGroupsPacketStatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListNodeGroupsPacketStat", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListNodeGroupsPacketStatResponse creates a response to parse from ListNodeGroupsPacketStat response
func CreateListNodeGroupsPacketStatResponse() (response *ListNodeGroupsPacketStatResponse) {
	response = &ListNodeGroupsPacketStatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
