package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveInstanceAccount invokes the drds.RemoveInstanceAccount API synchronously
func (client *Client) RemoveInstanceAccount(request *RemoveInstanceAccountRequest) (response *RemoveInstanceAccountResponse, err error) {
	response = CreateRemoveInstanceAccountResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveInstanceAccountWithChan invokes the drds.RemoveInstanceAccount API asynchronously
func (client *Client) RemoveInstanceAccountWithChan(request *RemoveInstanceAccountRequest) (<-chan *RemoveInstanceAccountResponse, <-chan error) {
	responseChan := make(chan *RemoveInstanceAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveInstanceAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveInstanceAccountWithCallback invokes the drds.RemoveInstanceAccount API asynchronously
func (client *Client) RemoveInstanceAccountWithCallback(request *RemoveInstanceAccountRequest, callback func(response *RemoveInstanceAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveInstanceAccountResponse
		var err error
		defer close(result)
		response, err = client.RemoveInstanceAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveInstanceAccountRequest is the request struct for api RemoveInstanceAccount
type RemoveInstanceAccountRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	AccountName    string `position:"Query" name:"AccountName"`
}

// RemoveInstanceAccountResponse is the response struct for api RemoveInstanceAccount
type RemoveInstanceAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRemoveInstanceAccountRequest creates a request to invoke RemoveInstanceAccount API
func CreateRemoveInstanceAccountRequest() (request *RemoveInstanceAccountRequest) {
	request = &RemoveInstanceAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "RemoveInstanceAccount", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveInstanceAccountResponse creates a response to parse from RemoveInstanceAccount response
func CreateRemoveInstanceAccountResponse() (response *RemoveInstanceAccountResponse) {
	response = &RemoveInstanceAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
