package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchDatabase invokes the dms_enterprise.SearchDatabase API synchronously
// api document: https://help.aliyun.com/api/dms-enterprise/searchdatabase.html
func (client *Client) SearchDatabase(request *SearchDatabaseRequest) (response *SearchDatabaseResponse, err error) {
	response = CreateSearchDatabaseResponse()
	err = client.DoAction(request, response)
	return
}

// SearchDatabaseWithChan invokes the dms_enterprise.SearchDatabase API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/searchdatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchDatabaseWithChan(request *SearchDatabaseRequest) (<-chan *SearchDatabaseResponse, <-chan error) {
	responseChan := make(chan *SearchDatabaseResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchDatabase(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchDatabaseWithCallback invokes the dms_enterprise.SearchDatabase API asynchronously
// api document: https://help.aliyun.com/api/dms-enterprise/searchdatabase.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchDatabaseWithCallback(request *SearchDatabaseRequest, callback func(response *SearchDatabaseResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchDatabaseResponse
		var err error
		defer close(result)
		response, err = client.SearchDatabase(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchDatabaseRequest is the request struct for api SearchDatabase
type SearchDatabaseRequest struct {
	*requests.RpcRequest
	SearchKey    string           `position:"Query" name:"SearchKey"`
	SearchRange  string           `position:"Query" name:"SearchRange"`
	Tid          requests.Integer `position:"Query" name:"Tid"`
	PageNumber   requests.Integer `position:"Query" name:"PageNumber"`
	SearchTarget string           `position:"Query" name:"SearchTarget"`
	PageSize     requests.Integer `position:"Query" name:"PageSize"`
	EnvType      string           `position:"Query" name:"EnvType"`
	DbType       string           `position:"Query" name:"DbType"`
}

// SearchDatabaseResponse is the response struct for api SearchDatabase
type SearchDatabaseResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	Success            bool               `json:"Success" xml:"Success"`
	ErrorMessage       string             `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode          string             `json:"ErrorCode" xml:"ErrorCode"`
	TotalCount         int64              `json:"TotalCount" xml:"TotalCount"`
	SearchDatabaseList SearchDatabaseList `json:"SearchDatabaseList" xml:"SearchDatabaseList"`
}

// CreateSearchDatabaseRequest creates a request to invoke SearchDatabase API
func CreateSearchDatabaseRequest() (request *SearchDatabaseRequest) {
	request = &SearchDatabaseRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "SearchDatabase", "dmsenterprise", "openAPI")
	return
}

// CreateSearchDatabaseResponse creates a response to parse from SearchDatabase response
func CreateSearchDatabaseResponse() (response *SearchDatabaseResponse) {
	response = &SearchDatabaseResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
