package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDcdnEsTemplateInfo invokes the dcdn.ListDcdnEsTemplateInfo API synchronously
func (client *Client) ListDcdnEsTemplateInfo(request *ListDcdnEsTemplateInfoRequest) (response *ListDcdnEsTemplateInfoResponse, err error) {
	response = CreateListDcdnEsTemplateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// ListDcdnEsTemplateInfoWithChan invokes the dcdn.ListDcdnEsTemplateInfo API asynchronously
func (client *Client) ListDcdnEsTemplateInfoWithChan(request *ListDcdnEsTemplateInfoRequest) (<-chan *ListDcdnEsTemplateInfoResponse, <-chan error) {
	responseChan := make(chan *ListDcdnEsTemplateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDcdnEsTemplateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDcdnEsTemplateInfoWithCallback invokes the dcdn.ListDcdnEsTemplateInfo API asynchronously
func (client *Client) ListDcdnEsTemplateInfoWithCallback(request *ListDcdnEsTemplateInfoRequest, callback func(response *ListDcdnEsTemplateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDcdnEsTemplateInfoResponse
		var err error
		defer close(result)
		response, err = client.ListDcdnEsTemplateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDcdnEsTemplateInfoRequest is the request struct for api ListDcdnEsTemplateInfo
type ListDcdnEsTemplateInfoRequest struct {
	*requests.RpcRequest
	Language   string           `position:"Query" name:"Language"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Op         string           `position:"Query" name:"Op"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// ListDcdnEsTemplateInfoResponse is the response struct for api ListDcdnEsTemplateInfo
type ListDcdnEsTemplateInfoResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	PageSize   int       `json:"PageSize" xml:"PageSize"`
	PageNumber int       `json:"PageNumber" xml:"PageNumber"`
	DataItems  DataItems `json:"DataItems" xml:"DataItems"`
}

// CreateListDcdnEsTemplateInfoRequest creates a request to invoke ListDcdnEsTemplateInfo API
func CreateListDcdnEsTemplateInfoRequest() (request *ListDcdnEsTemplateInfoRequest) {
	request = &ListDcdnEsTemplateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "ListDcdnEsTemplateInfo", "", "")
	request.Method = requests.GET
	return
}

// CreateListDcdnEsTemplateInfoResponse creates a response to parse from ListDcdnEsTemplateInfo response
func CreateListDcdnEsTemplateInfoResponse() (response *ListDcdnEsTemplateInfoResponse) {
	response = &ListDcdnEsTemplateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
