package crm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveIdentityCertifiedForBidUser invokes the crm.RemoveIdentityCertifiedForBidUser API synchronously
// api document: https://help.aliyun.com/api/crm/removeidentitycertifiedforbiduser.html
func (client *Client) RemoveIdentityCertifiedForBidUser(request *RemoveIdentityCertifiedForBidUserRequest) (response *RemoveIdentityCertifiedForBidUserResponse, err error) {
	response = CreateRemoveIdentityCertifiedForBidUserResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveIdentityCertifiedForBidUserWithChan invokes the crm.RemoveIdentityCertifiedForBidUser API asynchronously
// api document: https://help.aliyun.com/api/crm/removeidentitycertifiedforbiduser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveIdentityCertifiedForBidUserWithChan(request *RemoveIdentityCertifiedForBidUserRequest) (<-chan *RemoveIdentityCertifiedForBidUserResponse, <-chan error) {
	responseChan := make(chan *RemoveIdentityCertifiedForBidUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveIdentityCertifiedForBidUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveIdentityCertifiedForBidUserWithCallback invokes the crm.RemoveIdentityCertifiedForBidUser API asynchronously
// api document: https://help.aliyun.com/api/crm/removeidentitycertifiedforbiduser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveIdentityCertifiedForBidUserWithCallback(request *RemoveIdentityCertifiedForBidUserRequest, callback func(response *RemoveIdentityCertifiedForBidUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveIdentityCertifiedForBidUserResponse
		var err error
		defer close(result)
		response, err = client.RemoveIdentityCertifiedForBidUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveIdentityCertifiedForBidUserRequest is the request struct for api RemoveIdentityCertifiedForBidUser
type RemoveIdentityCertifiedForBidUserRequest struct {
	*requests.RpcRequest
	BidType string `position:"Query" name:"BidType"`
	PK      string `position:"Query" name:"PK"`
}

// RemoveIdentityCertifiedForBidUserResponse is the response struct for api RemoveIdentityCertifiedForBidUser
type RemoveIdentityCertifiedForBidUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateRemoveIdentityCertifiedForBidUserRequest creates a request to invoke RemoveIdentityCertifiedForBidUser API
func CreateRemoveIdentityCertifiedForBidUserRequest() (request *RemoveIdentityCertifiedForBidUserRequest) {
	request = &RemoveIdentityCertifiedForBidUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Crm", "2015-04-08", "RemoveIdentityCertifiedForBidUser", "crm", "openAPI")
	return
}

// CreateRemoveIdentityCertifiedForBidUserResponse creates a response to parse from RemoveIdentityCertifiedForBidUser response
func CreateRemoveIdentityCertifiedForBidUserResponse() (response *RemoveIdentityCertifiedForBidUserResponse) {
	response = &RemoveIdentityCertifiedForBidUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
