package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVnChatbotInstances invokes the cloudcallcenter.ListVnChatbotInstances API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnchatbotinstances.html
func (client *Client) ListVnChatbotInstances(request *ListVnChatbotInstancesRequest) (response *ListVnChatbotInstancesResponse, err error) {
	response = CreateListVnChatbotInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// ListVnChatbotInstancesWithChan invokes the cloudcallcenter.ListVnChatbotInstances API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnchatbotinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnChatbotInstancesWithChan(request *ListVnChatbotInstancesRequest) (<-chan *ListVnChatbotInstancesResponse, <-chan error) {
	responseChan := make(chan *ListVnChatbotInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVnChatbotInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVnChatbotInstancesWithCallback invokes the cloudcallcenter.ListVnChatbotInstances API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listvnchatbotinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVnChatbotInstancesWithCallback(request *ListVnChatbotInstancesRequest, callback func(response *ListVnChatbotInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVnChatbotInstancesResponse
		var err error
		defer close(result)
		response, err = client.ListVnChatbotInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVnChatbotInstancesRequest is the request struct for api ListVnChatbotInstances
type ListVnChatbotInstancesRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListVnChatbotInstancesResponse is the response struct for api ListVnChatbotInstances
type ListVnChatbotInstancesResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	TotalCount int64  `json:"TotalCount" xml:"TotalCount"`
	PageSize   int64  `json:"PageSize" xml:"PageSize"`
	Bots       []Bot  `json:"Bots" xml:"Bots"`
}

// CreateListVnChatbotInstancesRequest creates a request to invoke ListVnChatbotInstances API
func CreateListVnChatbotInstancesRequest() (request *ListVnChatbotInstancesRequest) {
	request = &ListVnChatbotInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListVnChatbotInstances", "", "")
	request.Method = requests.GET
	return
}

// CreateListVnChatbotInstancesResponse creates a response to parse from ListVnChatbotInstances response
func CreateListVnChatbotInstancesResponse() (response *ListVnChatbotInstancesResponse) {
	response = &ListVnChatbotInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
