package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTestPhoneNumber invokes the cloudcallcenter.AddTestPhoneNumber API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addtestphonenumber.html
func (client *Client) AddTestPhoneNumber(request *AddTestPhoneNumberRequest) (response *AddTestPhoneNumberResponse, err error) {
	response = CreateAddTestPhoneNumberResponse()
	err = client.DoAction(request, response)
	return
}

// AddTestPhoneNumberWithChan invokes the cloudcallcenter.AddTestPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addtestphonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddTestPhoneNumberWithChan(request *AddTestPhoneNumberRequest) (<-chan *AddTestPhoneNumberResponse, <-chan error) {
	responseChan := make(chan *AddTestPhoneNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTestPhoneNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTestPhoneNumberWithCallback invokes the cloudcallcenter.AddTestPhoneNumber API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/addtestphonenumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddTestPhoneNumberWithCallback(request *AddTestPhoneNumberRequest, callback func(response *AddTestPhoneNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTestPhoneNumberResponse
		var err error
		defer close(result)
		response, err = client.AddTestPhoneNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTestPhoneNumberRequest is the request struct for api AddTestPhoneNumber
type AddTestPhoneNumberRequest struct {
	*requests.RpcRequest
	Trunks      requests.Integer `position:"Query" name:"Trunks"`
	Number      string           `position:"Query" name:"Number"`
	InboundOnly requests.Boolean `position:"Query" name:"InboundOnly"`
}

// AddTestPhoneNumberResponse is the response struct for api AddTestPhoneNumber
type AddTestPhoneNumberResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Success        bool        `json:"Success" xml:"Success"`
	Code           string      `json:"Code" xml:"Code"`
	Message        string      `json:"Message" xml:"Message"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	PhoneNumber    PhoneNumber `json:"PhoneNumber" xml:"PhoneNumber"`
}

// CreateAddTestPhoneNumberRequest creates a request to invoke AddTestPhoneNumber API
func CreateAddTestPhoneNumberRequest() (request *AddTestPhoneNumberRequest) {
	request = &AddTestPhoneNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "AddTestPhoneNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateAddTestPhoneNumberResponse creates a response to parse from AddTestPhoneNumber response
func CreateAddTestPhoneNumberResponse() (response *AddTestPhoneNumberResponse) {
	response = &AddTestPhoneNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
