package alimt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTranslateReport invokes the alimt.GetTranslateReport API synchronously
func (client *Client) GetTranslateReport(request *GetTranslateReportRequest) (response *GetTranslateReportResponse, err error) {
	response = CreateGetTranslateReportResponse()
	err = client.DoAction(request, response)
	return
}

// GetTranslateReportWithChan invokes the alimt.GetTranslateReport API asynchronously
func (client *Client) GetTranslateReportWithChan(request *GetTranslateReportRequest) (<-chan *GetTranslateReportResponse, <-chan error) {
	responseChan := make(chan *GetTranslateReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTranslateReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTranslateReportWithCallback invokes the alimt.GetTranslateReport API asynchronously
func (client *Client) GetTranslateReportWithCallback(request *GetTranslateReportRequest, callback func(response *GetTranslateReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTranslateReportResponse
		var err error
		defer close(result)
		response, err = client.GetTranslateReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTranslateReportRequest is the request struct for api GetTranslateReport
type GetTranslateReportRequest struct {
	*requests.RpcRequest
	EndTime   string `position:"Query" name:"EndTime"`
	BeginTime string `position:"Query" name:"BeginTime"`
	ApiName   string `position:"Query" name:"ApiName"`
	Group     string `position:"Query" name:"Group"`
}

// GetTranslateReportResponse is the response struct for api GetTranslateReport
type GetTranslateReportResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateGetTranslateReportRequest creates a request to invoke GetTranslateReport API
func CreateGetTranslateReportRequest() (request *GetTranslateReportRequest) {
	request = &GetTranslateReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alimt", "2018-10-12", "GetTranslateReport", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTranslateReportResponse creates a response to parse from GetTranslateReport response
func CreateGetTranslateReportResponse() (response *GetTranslateReportResponse) {
	response = &GetTranslateReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
