package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrUpdateDingTalk invokes the aegis.CreateOrUpdateDingTalk API synchronously
// api document: https://help.aliyun.com/api/aegis/createorupdatedingtalk.html
func (client *Client) CreateOrUpdateDingTalk(request *CreateOrUpdateDingTalkRequest) (response *CreateOrUpdateDingTalkResponse, err error) {
	response = CreateCreateOrUpdateDingTalkResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrUpdateDingTalkWithChan invokes the aegis.CreateOrUpdateDingTalk API asynchronously
// api document: https://help.aliyun.com/api/aegis/createorupdatedingtalk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateOrUpdateDingTalkWithChan(request *CreateOrUpdateDingTalkRequest) (<-chan *CreateOrUpdateDingTalkResponse, <-chan error) {
	responseChan := make(chan *CreateOrUpdateDingTalkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrUpdateDingTalk(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrUpdateDingTalkWithCallback invokes the aegis.CreateOrUpdateDingTalk API asynchronously
// api document: https://help.aliyun.com/api/aegis/createorupdatedingtalk.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateOrUpdateDingTalkWithCallback(request *CreateOrUpdateDingTalkRequest, callback func(response *CreateOrUpdateDingTalkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrUpdateDingTalkResponse
		var err error
		defer close(result)
		response, err = client.CreateOrUpdateDingTalk(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrUpdateDingTalkRequest is the request struct for api CreateOrUpdateDingTalk
type CreateOrUpdateDingTalkRequest struct {
	*requests.RpcRequest
	RuleActionName string           `position:"Query" name:"RuleActionName"`
	SourceIp       string           `position:"Query" name:"SourceIp"`
	SendUrl        string           `position:"Query" name:"SendUrl"`
	Id             requests.Integer `position:"Query" name:"Id"`
	IntervalTime   requests.Integer `position:"Query" name:"IntervalTime"`
}

// CreateOrUpdateDingTalkResponse is the response struct for api CreateOrUpdateDingTalk
type CreateOrUpdateDingTalkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateOrUpdateDingTalkRequest creates a request to invoke CreateOrUpdateDingTalk API
func CreateCreateOrUpdateDingTalkRequest() (request *CreateOrUpdateDingTalkRequest) {
	request = &CreateOrUpdateDingTalkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "CreateOrUpdateDingTalk", "vipaegis", "openAPI")
	return
}

// CreateCreateOrUpdateDingTalkResponse creates a response to parse from CreateOrUpdateDingTalk response
func CreateCreateOrUpdateDingTalkResponse() (response *CreateOrUpdateDingTalkResponse) {
	response = &CreateOrUpdateDingTalkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
