'use client';
'use strict';

var jsxRuntime = require('react/jsx-runtime');
var react = require('react');
var cx = require('clsx');
var hljs = require('highlight.js');
var core = require('@mantine/core');
var hooks = require('@mantine/hooks');
var CopyIcon = require('./CopyIcon.cjs');
var ExpandIcon = require('./ExpandIcon.cjs');
var FileIcon = require('./FileIcon.cjs');
var CodeHighlight_module = require('./CodeHighlight.module.css.cjs');
var CodeHighlight_theme_module = require('./CodeHighlight.theme.module.css.cjs');

function _interopDefault (e) { return e && e.__esModule ? e : { default: e }; }

var cx__default = /*#__PURE__*/_interopDefault(cx);
var hljs__default = /*#__PURE__*/_interopDefault(hljs);

const classes = { ...CodeHighlight_module, root: cx__default.default(CodeHighlight_module.root, CodeHighlight_theme_module.theme) };
const defaultProps = {
  withHeader: true,
  copyLabel: "Copy code",
  copiedLabel: "Copied",
  maxCollapsedHeight: core.rem("8rem"),
  expandCodeLabel: "Expand code",
  collapseCodeLabel: "Collapse code",
  withCopyButton: true
};
const varsResolver = core.createVarsResolver((_, { maxCollapsedHeight }) => ({
  root: { "--ch-max-collapsed-height": core.rem(maxCollapsedHeight) }
}));
const CodeHighlightTabs = core.factory((_props, ref) => {
  const props = core.useProps("CodeHighlightTabs", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    children,
    code,
    defaultActiveTab,
    activeTab,
    onTabChange,
    withHeader,
    copiedLabel,
    copyLabel,
    getFileIcon,
    maxCollapsedHeight,
    expanded,
    defaultExpanded,
    onExpandedChange,
    expandCodeLabel,
    collapseCodeLabel,
    withExpandButton,
    withCopyButton,
    mod,
    ...others
  } = props;
  const getStyles = core.useStyles({
    name: "CodeHighlightTabs",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled,
    vars,
    varsResolver
  });
  const [value, setValue] = hooks.useUncontrolled({
    defaultValue: defaultActiveTab,
    value: activeTab,
    finalValue: 0,
    onChange: onTabChange
  });
  const [_expanded, setExpanded] = hooks.useUncontrolled({
    defaultValue: defaultExpanded,
    value: expanded,
    finalValue: true,
    onChange: onExpandedChange
  });
  const nodes = Array.isArray(code) ? code : [code];
  const currentCode = nodes[value];
  const language = currentCode.language != null ? hljs__default.default.getLanguage(currentCode.language ?? "") ? currentCode.language : "plaintext" : "plaintext";
  const highlighted = hljs__default.default.highlight(currentCode.code.trim(), {
    language
  }).value;
  const files = nodes.map((node, index) => /* @__PURE__ */ react.createElement(
    core.UnstyledButton,
    {
      ...getStyles("file"),
      key: node.fileName,
      mod: { active: index === value },
      onClick: () => setValue(index)
    },
    /* @__PURE__ */ jsxRuntime.jsx(
      FileIcon.FileIcon,
      {
        fileIcon: node.icon,
        getFileIcon,
        fileName: node.fileName,
        ...getStyles("fileIcon")
      }
    ),
    /* @__PURE__ */ jsxRuntime.jsx("span", { children: node.fileName })
  ));
  return /* @__PURE__ */ jsxRuntime.jsxs(
    core.Box,
    {
      ...getStyles("root"),
      mod: [{ collapsed: !_expanded }, mod],
      ref,
      ...others,
      dir: "ltr",
      children: [
        withHeader && /* @__PURE__ */ jsxRuntime.jsxs("div", { ...getStyles("header"), children: [
          /* @__PURE__ */ jsxRuntime.jsx(core.ScrollArea, { type: "never", dir: "ltr", offsetScrollbars: false, children: /* @__PURE__ */ jsxRuntime.jsx("div", { ...getStyles("files"), children: files }) }),
          /* @__PURE__ */ jsxRuntime.jsxs("div", { ...getStyles("controls"), children: [
            withExpandButton && /* @__PURE__ */ jsxRuntime.jsx(
              core.Tooltip,
              {
                label: _expanded ? collapseCodeLabel : expandCodeLabel,
                fz: "sm",
                position: "left",
                children: /* @__PURE__ */ jsxRuntime.jsx(
                  core.ActionIcon,
                  {
                    onClick: () => setExpanded(!_expanded),
                    variant: "none",
                    "aria-label": _expanded ? collapseCodeLabel : expandCodeLabel,
                    ...getStyles("control"),
                    children: /* @__PURE__ */ jsxRuntime.jsx(ExpandIcon.ExpandIcon, { expanded: _expanded })
                  }
                )
              }
            ),
            withCopyButton && /* @__PURE__ */ jsxRuntime.jsx(core.CopyButton, { value: currentCode.code.trim(), children: ({ copied, copy }) => /* @__PURE__ */ jsxRuntime.jsx(core.Tooltip, { label: copied ? copiedLabel : copyLabel, fz: "sm", position: "left", children: /* @__PURE__ */ jsxRuntime.jsx(
              core.ActionIcon,
              {
                onClick: copy,
                variant: "none",
                ...getStyles("control"),
                "aria-label": copied ? copiedLabel : copyLabel,
                children: /* @__PURE__ */ jsxRuntime.jsx(CopyIcon.CopyIcon, { copied })
              }
            ) }) })
          ] })
        ] }),
        /* @__PURE__ */ jsxRuntime.jsx(core.ScrollArea, { type: "auto", dir: "ltr", offsetScrollbars: false, children: /* @__PURE__ */ jsxRuntime.jsx(core.Box, { ...getStyles("codeWrapper"), mod: { expanded: _expanded }, children: /* @__PURE__ */ jsxRuntime.jsx("pre", { ...getStyles("pre"), children: /* @__PURE__ */ jsxRuntime.jsx("code", { ...getStyles("code"), dangerouslySetInnerHTML: { __html: highlighted } }) }) }) }),
        /* @__PURE__ */ jsxRuntime.jsx(
          core.UnstyledButton,
          {
            ...getStyles("showCodeButton"),
            mod: { hidden: _expanded },
            onClick: () => setExpanded(true),
            children: expandCodeLabel
          }
        )
      ]
    }
  );
});
CodeHighlightTabs.displayName = "@mantine/core/CodeHighlightTabs";
CodeHighlightTabs.classes = classes;

exports.CodeHighlightTabs = CodeHighlightTabs;
//# sourceMappingURL=CodeHighlightTabs.cjs.map
