/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.ior;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.spi.activation.Activator;
import com.sun.corba.se.spi.activation._ActivatorStub;
import com.sun.corba.se.spi.activation._InitialNameServiceStub;
import com.sun.corba.se.spi.activation._LocatorStub;
import com.sun.corba.se.spi.activation._RepositoryStub;
import com.sun.corba.se.spi.activation._ServerManagerStub;
import com.sun.corba.se.spi.activation._ServerStub;
import com.sun.corba.se.spi.ior.IORTypeCheckRegistry;
import com.sun.corba.se.spi.orb.ORB;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming._BindingIteratorStub;
import org.omg.CosNaming._NamingContextExtStub;
import org.omg.CosNaming._NamingContextStub;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynArray;
import org.omg.DynamicAny.DynEnum;
import org.omg.DynamicAny.DynFixed;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.DynValue;
import org.omg.DynamicAny._DynAnyFactoryStub;
import org.omg.DynamicAny._DynAnyStub;
import org.omg.DynamicAny._DynArrayStub;
import org.omg.DynamicAny._DynEnumStub;
import org.omg.DynamicAny._DynFixedStub;
import org.omg.DynamicAny._DynSequenceStub;
import org.omg.DynamicAny._DynStructStub;
import org.omg.DynamicAny._DynUnionStub;
import org.omg.DynamicAny._DynValueStub;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer._ServantActivatorStub;
import org.omg.PortableServer._ServantLocatorStub;

public class IORTypeCheckRegistryImpl
implements IORTypeCheckRegistry {
    private final Set<String> iorTypeNames;
    private static final Set<String> builtinIorTypeNames = IORTypeCheckRegistryImpl.initBuiltinIorTypeNames();
    private ORB theOrb;

    public IORTypeCheckRegistryImpl(String string, ORB oRB) {
        this.theOrb = oRB;
        this.iorTypeNames = this.parseIorClassNameList(string);
    }

    @Override
    public boolean isValidIORType(String string) {
        this.dprintTransport(".isValidIORType : iorClassName == " + string);
        return this.validateIorTypeByName(string);
    }

    private boolean validateIorTypeByName(String string) {
        this.dprintTransport(".validateIorTypeByName : iorClassName == " + string);
        boolean bl = this.checkIorTypeNames(string);
        if (!bl) {
            bl = this.checkBuiltinClassNames(string);
        }
        this.dprintTransport(".validateIorTypeByName : isValidType == " + bl);
        return bl;
    }

    private boolean checkIorTypeNames(String string) {
        return this.iorTypeNames != null && this.iorTypeNames.contains(string);
    }

    private boolean checkBuiltinClassNames(String string) {
        return builtinIorTypeNames.contains(string);
    }

    private Set<String> parseIorClassNameList(String string) {
        Set<String> set = null;
        if (string != null) {
            String[] stringArray = string.split(";");
            set = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
            if (this.theOrb.orbInitDebugFlag) {
                this.dprintConfiguredIorTypeNames();
            }
        }
        return set;
    }

    private static Set<String> initBuiltinIorTypeNames() {
        Set<Class<?>> set = IORTypeCheckRegistryImpl.initBuiltInCorbaStubTypes();
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (Class<?> clazz : set) {
            stringArray[n++] = clazz.getName();
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(stringArray)));
    }

    private static Set<Class<?>> initBuiltInCorbaStubTypes() {
        Class[] classArray = new Class[]{Activator.class, _ActivatorStub.class, _InitialNameServiceStub.class, _LocatorStub.class, _RepositoryStub.class, _ServerManagerStub.class, _ServerStub.class, BindingIterator.class, _BindingIteratorStub.class, NamingContextExt.class, _NamingContextExtStub.class, NamingContext.class, _NamingContextStub.class, DynAnyFactory.class, _DynAnyFactoryStub.class, DynAny.class, _DynAnyStub.class, DynArray.class, _DynArrayStub.class, DynEnum.class, _DynEnumStub.class, DynFixed.class, _DynFixedStub.class, DynSequence.class, _DynSequenceStub.class, DynStruct.class, _DynStructStub.class, DynUnion.class, _DynUnionStub.class, _DynValueStub.class, DynValue.class, ServantActivator.class, _ServantActivatorStub.class, ServantLocator.class, _ServantLocatorStub.class};
        return new HashSet(Arrays.asList(classArray));
    }

    private void dprintConfiguredIorTypeNames() {
        if (this.iorTypeNames != null) {
            for (String string : this.iorTypeNames) {
                ORBUtility.dprint(this, ".dprintConfiguredIorTypeNames: " + string);
            }
        }
    }

    private void dprintTransport(String string) {
        if (this.theOrb.transportDebugFlag) {
            ORBUtility.dprint(this, string);
        }
    }
}

