/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef TN93M_H
#define TN93M_H

#include "basem.h"
/*
general time reversible model
*/
class TN93M: public BaseM {
public :


	/**
		all things are inited here
	*/
	virtual void init ();
	
	/**
		optimize parameters
	*/
	virtual bool optPam (const PAM_TYPE tsTvRatioType, const PAM_TYPE pyPuRatioTyp);

	/**
		Reinitialize
	*/
	void reInit ();
	
	/**
		compute the log likelihood when given a value
		this function is used to optimize the parameter of this model
	*/
	virtual double cmpNegLogLi (double value);

	/**
		Create the Rate parameters (not the rate matrix)
	*/
	void createRateParameters ();


	/**
		release all memmory for this class
	*/
	void release ();

}
; //end of General model class
#endif
