/***************************************************************************
 *                                                                         *
 *                                                                         *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "codonposrate.h"
#include <assert.h>
#include "opturtree.h"
#include "model.h"

const double MIN_POS_RATIO = 0.001;
const double MAX_POS_RATIO = 10.0;


CodonPosRate::CodonPosRate () : CodonYN98()
{
	pos3Ratio = 1.0;
	pos2Ratio = 1.0;
}

/**
		calculate the rate parameters (not rate matrix)
*/
void CodonPosRate::calcRateParameters() {

	for (int i = 0; i < NUM_CODON; i++)
		for (int j = i+1; j < NUM_CODON; j++) {
			if (codon_trans[i][j].source == 0) { // more than 2 different codon positions
				continue;
			}
			//unitRateMat_[i][j]
			if (codon_trans[i][j].is_transition)
				if (codon_trans[i][j].is_synonymous)
					// synonymous transition
					unitRateMat_[i][j] = tsTvRatio_;
				else // nonsynonymous transition
					unitRateMat_[i][j] = tsTvRatio_ * nsSyRatio;
			else
				if (codon_trans[i][j].is_synonymous)
					// synonymous transversion
					unitRateMat_[i][j] = 1.0;
				else
					// nonsynonymous transversion
					unitRateMat_[i][j] = nsSyRatio;

			if (codon_trans[i][j].position == 3)
				unitRateMat_[i][j] *= pos3Ratio;
			else if (codon_trans[i][j].position == 2)
				unitRateMat_[i][j] *= pos2Ratio;
					
			unitRateMat_[j][i] = unitRateMat_[i][j];
		}
	/*
	for (int i = 0; i < NUM_CODON; i++)
		for (int j = i+1; j < NUM_CODON; j++) {
			if (codon_trans[i][j].source == 0) { // more than 2 different codon positions
				continue;
			}
			unitRateMat_[i][j] /= sum;
			unitRateMat_[j][i] /= sum;
		}*/
}

double CodonPosRate::cmpNegLogLi (double value) {
	if (isActPam_ == TS_TV_RATIO)
		tsTvRatio_ = value;
	else if (isActPam_ == NS_SY_RATIO)
		nsSyRatio = value;
	else if (isActPam_ == POS3_RATIO)
		pos3Ratio = value;
	else if (isActPam_ == POS2_RATIO)
		pos2Ratio = value;

	reInit ();

	opt_urtree.cmpLiNd ();
	//opt_urtree.opt (MAX_IT_UR_BR_PAM_OPT);
	double logLi_ = opt_urtree.getLogLi ();
	return -logLi_;
}


bool CodonPosRate::optPam () {
	double fx_, error_;
	double oriTsTvRatio_ = tsTvRatio_;
	double oriNsSyRatio = nsSyRatio;
	double oriPos3Ratio = pos3Ratio;
	double oriPos2Ratio = pos2Ratio;

	//  double logLi_ = opt_urtree.getLogLi ();
	if (isMasterProc())
		std::cout <<"Optimizing miscenlanous codon-based model parameters ..." << endl;
	Brent::turnOnOptedPam ();
	double logLi_ = opt_urtree.cmpLogLi ();
	//  std::cout <<"Log likelihood: " << logLi_ << endl;


	if (mymodel.getTsTvRatioType() == ESTIMATE) {
		isActPam_ = TS_TV_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing transition/transversion ratio..." << endl;
		tsTvRatio_ = Brent::optOneDim (MIN_TS_TV_RATIO, tsTvRatio_, MAX_TS_TV_RATIO,
		                               EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();
	}//end of optimizing tsTvRatio

	if (true) {
		isActPam_ = NS_SY_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing nonsynonymous/synonymous ratio..." << endl;
		nsSyRatio = Brent::optOneDim (MIN_NS_SY_RATIO, nsSyRatio, MAX_NS_SY_RATIO,
		                              EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();

	}

	if (true) {
		isActPam_ = POS3_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing 3rd position ratio..." << endl;
		pos3Ratio = Brent::optOneDim (MIN_POS_RATIO, pos3Ratio, MAX_POS_RATIO,
		                              EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();

	}
	/*
	if (true) {
		isActPam_ = POS2_RATIO;
		if (isMasterProc())
			std::cout <<"   Optimizing 2nd position ratio..." << endl;
		pos2Ratio = Brent::optOneDim (MIN_POS_RATIO, pos2Ratio, MAX_POS_RATIO,
		                              EPS_MODEL_PAM_ERROR, &fx_, &error_);
		reInit ();

	}
	*/
	//      logLi_ = opt_urtree.cmpLogLi ();
	//     std::cout <<"Log likelihood: " << logLi_ << endl;
	//------------------------------/------------------------------/





	opt_urtree.cmpLiNd ();
	logLi_ = opt_urtree.getLogLi ();

	std::cout.precision (10);
	//  std::cout << "Log likelihood: " << logLi_ << endl;

	if (isMasterProc()) {

		std::cout.precision (5);
		std::cout << "Transition/transversion ratio  =  " << tsTvRatio_/2.0 << endl;
		std::cout << "Nonsynonymous/synonymous ratio =  " << nsSyRatio << endl ;
		std::cout << "3rd position ratio =  " << pos3Ratio << endl;
		std::cout << "2nd position ratio =  " << pos2Ratio << endl;
	}

	Brent::turnOffOptedPam ();
	return (fabs (tsTvRatio_ - oriTsTvRatio_) > EPS_MODEL_PAM_ERROR ||
	        fabs (nsSyRatio - oriNsSyRatio) > EPS_MODEL_PAM_ERROR ||
	        fabs (pos3Ratio - oriPos3Ratio) > EPS_MODEL_PAM_ERROR ||
	        fabs (pos2Ratio - oriPos2Ratio) > EPS_MODEL_PAM_ERROR );
}


CodonPosRate::~CodonPosRate()
{
}


