/***************************************************************************
 *                                                                         *
 *   brent.h     (begin: Feb 20 2003)                                      *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef BRENT_H
#define BRENT_H

#include "simanneal.h"

#define MAX_DIMENSION 20
const double EPS_BOUND = 1.0e-4;

typedef double DOUBLE_VECTOR[MAX_DIMENSION];

/**
	This class includes some methods for optimizing function using Brent's method.
*/
class Brent : public SimAnneal {
public:


	//the constructor function
	Brent();

	/**
		compute the negative log likelihood according to a value
	*/
	virtual double cmpNegLogLi(double value) { return 0; }
	
	/* one-dimensional minimization - as input a lower and an upper limit and a trial
	value for the minimum is needed: xmin < xguess < xmax
	the function and a fractional tolerance has to be specified
	onedimenmin returns the optimal x value and the value of the function
	and its second derivative at this point
	*/

	double optOneDim(double xmin, double xguess, double xmax, double tol, double *fx, double *f2x);
	double optOneDim_old(double xmin, double xguess, double xmax, double tol, double *fx, double *f2x);

	/* multi-dimensional minimization - as input lower limits and upper limits and trial
	values for the minimums are needed: min1 < *x1 < max1; min2 < *x2 < max2
	the function and a fractional tolerance has to be specified
	optimizeTwodimenmin returns the optimal x1, x2 values and the value of their second derivatives at these points
	*/
	
	void powell(double p[], double **xi, int n, double ftol, int *iter, double *fret);

	void initOptMulti(int ndim);
	/**
		multi dimensional optimization by powell method
		@param guess the initial starting point
		@param ndim number of dimension
		@param ftol tolerance
		@return the minimum function value obtained
	*/
	double optMultiDim(double guess[], int ndim, double ftol);

	/**
		multi dimensional optimization by BFGS method
		@param guess the initial starting point
		@param ndim number of dimension
		@param gtol tolerance
		@param lower the lower bound vector
		@param upper the upper bound vector
		@return the minimum function value obtained
	*/
	double optMultiDim(double guess[], int ndim, double lower[], double upper[], bool bound_check[], double gtol);
	
	
	void dfpmin(double p[], int n, double lower[], double upper[], double gtol, int *iter, double *fret);
	
		
	void turnOnOptedPam ();
	void turnOffOptedPam ();
	int isOptedPam ();

	//release all memmory for this class
	void release ();

	//the destructor function
	virtual ~Brent ();

	/***************************************************************************************
	***************************************************************************************
	 
	***************************************************************************************
	***************************************************************************************/
protected:
	/* Brents method in one dimension */
	double opt (double ax, double bx, double cx, double tol, double *foptx, double *f2optx, double fax, double fbx, double fcx);
	
	double brent(double ax, double bx, double cx, double tol, double *xmin);
	
	void linmin(double p[], double xi[], int n, double *fret);
	double f1dim(double x);
	void mnbrak(double *ax, double *bx, double *cx, double *fa, double *fb, double *fc);
	void lnsrch(int n, double xold[], double fold, double g[], double p[], double x[],
		double *f, double stpmax, int *check, double lower[], double upper[]);
	
	int isOptedPam_;

	double* direction_set[MAX_DIMENSION];
	
}
; //end of class

#endif
