//
// C++ Implementation: aminocustom
//
// Description: 
//
//
// Author: Bui Quang Minh <minh@cs.uni-duesseldorf.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "aminocustom.h"


void AminoCustom::getData (char *filename, DMat20 &q, DVec20 &f) {
	cout << "Reading amino acid replacement rates and frequencies from file " << filename << " ..." << endl;
	try {
		ifstream in;
		in.exceptions(ios::failbit | ios::badbit);
		in.open(filename);
		int nstate = NUM_AMINO;
		int i, j;
		for (i = 1; i < nstate; i++) 
			for (j = 0; j < i; j++)
				in >> q[j][i];
		for (i = 0; i < nstate; i++)
			in >> f[i];
		in.close();
	} catch (ios::failure) {
		cout << "File not found or incorrect format" << endl;
		Finalize(1);
	}
}

