/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBTableSorter;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ReturnAttributesDisplay
implements DataListener {
    private static Logger log = Logger.getLogger(ReturnAttributesDisplay.class.getName());
    private JXplorerBrowser browser;
    private DataBrokerQueryInterface dataSource = null;
    private Object[][] tableData = null;
    private String[] tableHeader = null;
    private static ReturnAttributesGUI gui = null;

    public ReturnAttributesDisplay(JXplorerBrowser jx, String[] tableHeader) {
        this.tableHeader = tableHeader;
        this.browser = jx;
    }

    public void registerDataSource(DataBrokerQueryInterface ds) {
        this.dataSource = ds;
        this.dataSource.addDataListener(this);
    }

    @Override
    public void dataReady(DataQuery result) {
        int type = result.getType();
        if (result.hasException()) {
            CBUtility.error("Unable to perform " + result.getTypeString() + " operation.", result.getException());
            return;
        }
        if (type == 8) {
            this.displaySearchResult(result);
        }
    }

    protected void displaySearchResult(DataQuery result) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        try {
            DXNamingEnumeration myResults = result.getEnumeration();
            Object[] searchResults = myResults.toArray();
            int rows = searchResults.length;
            int cols = this.tableHeader.length;
            if (rows == 0) {
                this.tableData = new Object[0][0];
            } else {
                this.tableData = new Object[rows][cols];
                String dn = "";
                Attribute att = null;
                String header = "";
                int includeDNPos = -1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        Attributes atts = ((SearchResult)searchResults[i]).getAttributes();
                        dn = ((SearchResult)searchResults[i]).getName();
                        att = atts.get(this.tableHeader[j]);
                        if (this.tableHeader[j].equalsIgnoreCase("[DN]")) {
                            includeDNPos = j;
                            this.tableData[i][j] = dn;
                            continue;
                        }
                        if (att == null) {
                            this.tableData[i][j] = "";
                            continue;
                        }
                        header = att.toString();
                        this.tableData[i][j] = header.substring(header.indexOf(":") + 2);
                    }
                    map.put(String.valueOf(i), dn);
                }
                if (includeDNPos > -1) {
                    this.tableHeader[includeDNPos] = "DN";
                }
            }
            if (this.tableData == null || this.tableHeader == null) {
                log.warning("Problem retrieving the search results for the Return Attributes display");
                return;
            }
            if (gui == null) {
                gui = new ReturnAttributesGUI(this.tableData, this.tableHeader, rows, map);
            } else {
                gui.setTableData(this.tableData, this.tableHeader, rows, map);
                gui.setVisible(true);
            }
        }
        catch (NamingException e) {
            result.setException(e);
        }
        catch (ClassCastException ee) {
            log.log(Level.WARNING, "Casting problem in return attribute display ", ee);
        }
        this.dataSource.removeDataListener(this);
    }

    private String escapeForCSV(String str) {
        if (str == null) {
            return str;
        }
        str = str.trim();
        str = str.replaceAll("\"", "\"\"");
        return "\"" + str + "\"";
    }

    class ReturnAttributesGUI
    extends JDialog
    implements Printable {
        JTable table;
        DefaultTableModel model;
        CBTableSorter sorter;
        CBButton btnPrint;
        CBButton btnClose;
        CBButton btnHelp;
        CBButton btnSave;
        CBPanel bottomPanel;
        CBPanel topPanel;
        CBPanel display;
        JScrollPane scrollPane;
        JFileChooser chooser;
        HashMap map;
        private Component printComponent;

        public ReturnAttributesGUI(Object[][] tableData, String[] tableHeader, int num, HashMap map) {
            super(ReturnAttributesDisplay.this.browser, CBIntText.get(String.valueOf(num) + " " + CBIntText.get("Search Results")), false);
            this.printComponent = null;
            this.map = map;
            this.model = new DefaultTableModel(tableData, tableHeader);
            this.sorter = new CBTableSorter(this.model);
            this.table = new JTable(this.sorter);
            this.sorter.addMouseListenerToHeaderInTable(this.table);
            this.addMouseListenerToTable();
            this.scrollPane = new JScrollPane(this.table);
            this.display = new CBPanel();
            this.topPanel = new CBPanel();
            this.topPanel.makeHeavy();
            this.topPanel.addln(this.scrollPane);
            this.display.makeHeavy();
            this.display.addln(this.topPanel);
            this.bottomPanel = new CBPanel();
            this.btnPrint = new CBButton(CBIntText.get("Print"), CBIntText.get("Print this page."));
            this.btnPrint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReturnAttributesGUI.this.print();
                }
            });
            this.btnSave = new CBButton(CBIntText.get("Save"), CBIntText.get("Save this page."));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReturnAttributesGUI.this.save();
                }
            });
            this.btnClose = new CBButton(CBIntText.get("Close"), CBIntText.get("Close this window."));
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReturnAttributesGUI.this.close();
                }
            });
            this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Help for this window."));
            CBHelpSystem.useDefaultHelp(this.btnHelp, "search.results");
            this.bottomPanel.makeWide();
            this.bottomPanel.add(new JLabel("  "));
            this.bottomPanel.makeLight();
            this.bottomPanel.add(this.btnPrint);
            this.bottomPanel.add(this.btnSave);
            this.bottomPanel.add(this.btnClose);
            this.bottomPanel.add(this.btnHelp);
            this.display.makeLight();
            this.display.addln(this.bottomPanel);
            Container pane = this.getContentPane();
            pane.setLayout(new BorderLayout());
            pane.add(this.display);
            this.setSize(500, 300);
            CBUtility.center(this, ReturnAttributesDisplay.this.browser);
            this.setVisible(true);
        }

        public void setTableData(Object[][] tableData, String[] tableHeader, int num, HashMap map) {
            this.map = map;
            this.setTitle(CBIntText.get(String.valueOf(num) + " " + CBIntText.get("Search Results")));
            this.topPanel.remove(this.scrollPane);
            this.model = new DefaultTableModel(tableData, tableHeader);
            this.sorter = new CBTableSorter(this.model);
            this.table = new JTable(this.sorter);
            this.addMouseListenerToTable();
            this.sorter.addMouseListenerToHeaderInTable(this.table);
            this.scrollPane = new JScrollPane(this.table);
            this.topPanel.add(this.scrollPane);
            this.repaint();
        }

        public void addMouseListenerToTable() {
            this.table.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!this.doPopupStuff(e)) {
                        super.mousePressed(e);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!this.doPopupStuff(e)) {
                        super.mouseReleased(e);
                    }
                }

                public boolean doPopupStuff(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        return false;
                    }
                    ReturnAttributesGUI.this.setUpPopup(e.getX(), e.getY());
                    return true;
                }
            });
        }

        public void setUpPopup(int x, int y) {
            JPopupMenu pop = new JPopupMenu("Go to");
            final JMenuItem menuItem = new JMenuItem(CBIntText.get("Go to entry..."), new ImageIcon(Theme.getInstance().getDirImages() + "goto.gif"));
            pop.add(menuItem);
            final int selectedRow = this.table.rowAtPoint(new Point(x, y));
            this.table.changeSelection(selectedRow, this.table.getSelectedColumn(), false, false);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JMenuItem src = (JMenuItem)e.getSource();
                    if (src == menuItem) {
                        ReturnAttributesGUI.this.goToEntry(selectedRow);
                    }
                }
            });
            pop.show(this.table, x, y);
        }

        public void goToEntry(int selectedRow) {
            SmartTree tree = ReturnAttributesDisplay.this.browser.getTree();
            Object temp = this.map.get(String.valueOf(this.sorter.getTrueIndex(selectedRow)));
            tree.collapse();
            tree.readAndExpandDN(new DN(temp.toString()));
            ReturnAttributesDisplay.this.browser.getTreeTabPane().setSelectedComponent(ReturnAttributesDisplay.this.browser.getExplorePanel());
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.black);
            Dimension d = this.printComponent.getSize();
            double panelWidth = d.width;
            double panelHeight = d.height;
            double pageHeight = pf.getImageableHeight();
            double pageWidth = pf.getImageableWidth();
            double scale = pageWidth / panelWidth;
            int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
            if (pageIndex >= totalNumPages) {
                return 1;
            }
            g2.translate(pf.getImageableX(), pf.getImageableY());
            g2.translate(0.0, (double)(-pageIndex) * pageHeight);
            g2.scale(scale, scale);
            this.printComponent.paint(g2);
            return 0;
        }

        public void print() {
            final PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintable(this);
            final JTable printMe = this.table;
            Thread worker = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (job.printDialog()) {
                        try {
                            6 var1_1 = this;
                            synchronized (var1_1) {
                                ReturnAttributesGUI.this.printComponent = printMe;
                                job.print();
                                ReturnAttributesGUI.this.printComponent = null;
                            }
                        }
                        catch (Exception ex) {
                            log.warning("error printing: " + ex);
                        }
                    }
                }
            };
            worker.start();
        }

        public void close() {
            this.setVisible(false);
            this.dispose();
        }

        public void save() {
            this.chooser = new JFileChooser(JXConfig.getProperty("csv.homeDir"));
            this.chooser.addChoosableFileFilter(new CBFileFilter(new String[]{"csv"}, "CSV Files (*.csv)"));
            int option = this.chooser.showSaveDialog(this);
            if (option == 0) {
                File readFile = this.chooser.getSelectedFile();
                if (readFile == null) {
                    CBUtility.error(CBIntText.get("Please select a file"));
                } else {
                    readFile = this.adjustFileName(readFile);
                    int response = -1;
                    if (readFile.exists() && (response = JOptionPane.showConfirmDialog(this, CBIntText.get("The File ''{0}'' already exists. Do you want to replace it?", new String[]{readFile.toString()}), CBIntText.get("Overwrite Confirmation"), 0)) != 0) {
                        this.save();
                    }
                    JXConfig.setProperty("csv.homeDir", readFile.getParent());
                    this.doFileWrite(readFile);
                }
            }
        }

        protected File adjustFileName(File file) {
            if (file == null) {
                return null;
            }
            if (file.exists()) {
                return file;
            }
            String name = file.getName();
            if (name.indexOf(46) != -1) {
                return file;
            }
            name = name + ".csv";
            return new File(file.getParentFile(), name);
        }

        protected void doFileWrite(File file) {
            if (file == null) {
                CBUtility.error(CBIntText.get("Unable to write to empty file"), null);
            }
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter(file);
                StringBuffer buffy = new StringBuffer(0);
                int cols = this.model.getColumnCount();
                int rows = this.model.getRowCount();
                String temp = "";
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        temp = this.model.getValueAt(i, j).toString();
                        buffy.append(ReturnAttributesDisplay.this.escapeForCSV(temp));
                        if (!(j == cols - 1)) {
                            buffy.append(",");
                        } else {
                            buffy.append("\n");
                        }
                        temp = "";
                    }
                }
                fileWriter.write(buffy.toString());
                fileWriter.close();
                log.warning("Closed CSV file");
                this.chooser.setVisible(false);
            }
            catch (Exception e) {
                log.warning("Error writing CSV file from Return Attributes dialog " + e);
            }
        }
    }
}

