/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.editor.basicbinaryeditor;
import com.ca.directory.jxplorer.editor.editablebinary;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class jpegphotoeditor
extends basicbinaryeditor {
    protected ImageIcon iconBytes;
    protected JLabel label;
    protected int imageHeight;
    protected int imageWidth;
    protected int screenHeight;
    protected int screenWidth;
    protected JScrollPane scrollPaneLabel;
    private static final Logger log = Logger.getLogger(jpegphotoeditor.class.getName());

    public jpegphotoeditor(Frame owner) {
        this(owner, false);
    }

    public jpegphotoeditor(Frame owner, boolean viewable) {
        super(owner);
        this.setTitle(CBIntText.get("jpegPhoto"));
        this.btnEdit.setVisible(false);
    }

    @Override
    public void addMainViewComponent() {
        this.label = new JLabel();
        this.scrollPaneLabel = new JScrollPane(this.label);
        this.display.makeHeavy();
        this.display.addln(this.scrollPaneLabel);
        this.display.makeLight();
    }

    @Override
    public CBButton addHelp() {
        this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help."));
        CBHelpSystem.useDefaultHelp(this.btnHelp, "edit.jpegphoto");
        return this.btnHelp;
    }

    public void preferredSize(int newWidth, int newHeight) {
        newHeight += 80;
        if (newWidth < 345) {
            newWidth = 345;
        }
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        this.screenWidth = toolKit.getScreenSize().width;
        this.screenHeight = toolKit.getScreenSize().height;
        if (newWidth >= this.screenWidth) {
            newWidth = this.screenWidth - 50;
        }
        if (newHeight >= this.screenHeight) {
            newHeight = this.screenHeight - 50;
        }
        this.setBounds((this.screenWidth - newWidth) / 2, (this.screenHeight - newHeight) / 2, newWidth, newHeight);
    }

    @Override
    public void setValue(editablebinary editMe) {
        this.editMe = editMe;
        this.bytes = editMe.getValue();
        this.oldBytes = this.bytes;
        if (this.bytes != null) {
            this.setButtons(true);
            this.iconBytes = new ImageIcon(this.bytes);
            this.imageHeight = this.iconBytes.getIconHeight();
            this.imageWidth = this.iconBytes.getIconWidth();
            this.preferredSize(this.imageWidth, this.imageHeight);
            this.label.setIcon(this.iconBytes);
        } else {
            this.preferredSize(400, 300);
            this.setButtons(false);
        }
    }

    @Override
    protected void load() {
        CBCache.cleanCache(this.currentDN.toString());
        JFileChooser chooser = new JFileChooser(JXConfig.getProperty("binary.homeDir"));
        chooser.addChoosableFileFilter(new CBFileFilter(new String[]{"jpeg", "jpg"}, "JPEG Files (*.jpeg, *.jpg)"));
        ImageAccessory ip = new ImageAccessory();
        chooser.setAccessory(ip);
        chooser.addPropertyChangeListener(ip);
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        JXConfig.setProperty("binary.homeDir", chooser.getSelectedFile().getParent());
        try {
            FileInputStream input = new FileInputStream(file);
            int length = (int)file.length();
            if (length > 0) {
                this.bytes = new byte[length];
                int read = input.read(this.bytes);
                if (read > 0) {
                    this.iconBytes = new ImageIcon(this.bytes);
                    this.imageHeight = this.iconBytes.getIconHeight();
                    this.imageWidth = this.iconBytes.getIconWidth();
                    this.label.setIcon(this.iconBytes);
                    this.preferredSize(this.imageWidth, this.imageHeight);
                    this.setButtons(true);
                }
            }
            input.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error opening the file!", e);
        }
        this.setVisible(false);
        this.setVisible(true);
    }

    @Override
    protected void save() {
        JFileChooser chooser = new JFileChooser(JXConfig.getProperty("binary.homeDir"));
        if (chooser.showSaveDialog(this.frame) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        try {
            FileOutputStream output = new FileOutputStream(file);
            output.write(this.bytes);
            output.close();
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Error writing to the file! ", e);
        }
    }

    @Override
    public void setButtons(boolean enabled) {
        this.btnOK.setEnabled(enabled);
        this.btnSave.setEnabled(enabled);
    }

    @Override
    public byte[] getNewValue() {
        if (this.bytes != null && this.bytes.length != 0) {
            return this.bytes;
        }
        return null;
    }

    @Override
    public void setValue() {
        if (this.isChanged()) {
            this.editMe.setValue(this.getNewValue());
        }
        this.quit();
    }

    public class ImageAccessory
    extends JComponent
    implements PropertyChangeListener {
        ImageIcon image = null;
        File file = null;

        public ImageAccessory() {
            this.setPreferredSize(new Dimension(100, 50));
        }

        public void loadImage() {
            if (this.file == null) {
                this.image = null;
                return;
            }
            ImageIcon tempImage = new ImageIcon(this.file.getPath());
            if (tempImage != null) {
                this.image = tempImage.getIconWidth() > 90 ? new ImageIcon(tempImage.getImage().getScaledInstance(90, -1, 1)) : tempImage;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean update = false;
            String prop = e.getPropertyName();
            if ("directoryChanged".equals(prop)) {
                this.file = null;
                update = true;
            } else if ("SelectedFileChangedProperty".equals(prop)) {
                this.file = (File)e.getNewValue();
                update = true;
            }
            if (update) {
                this.image = null;
                if (this.isShowing()) {
                    this.loadImage();
                    this.repaint();
                }
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.image == null) {
                this.loadImage();
            }
            if (this.image != null) {
                int x = this.getWidth() / 2 - this.image.getIconWidth() / 2;
                int y = this.getHeight() / 2 - this.image.getIconHeight() / 2;
                if (y < 0) {
                    y = 0;
                }
                if (x < 5) {
                    x = 5;
                }
                this.image.paintIcon(this, g, x, y);
            }
        }
    }
}

