/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBLauncher;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.editor.defaultbinaryeditor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JComponent;

public class baseodmediaeditor
extends defaultbinaryeditor {
    protected File file = null;
    protected String title = "BaseODMediaEditor";
    protected String fileName = "BaseODMediaEditor";
    protected String extension = "";
    private static Logger log = Logger.getLogger(baseodmediaeditor.class.getName());

    public baseodmediaeditor(Frame owner) {
        super(owner);
        this.setDialogTitle(this.title);
    }

    @Override
    public void setDialogTitle(String title) {
        this.title = title;
        super.setDialogTitle(CBIntText.get(title));
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setExtension(String extension) {
        this.extension = extension;
        this.addChoosableFileFilter(new CBFileFilter(new String[]{extension}, this.fileName + " Files (*" + extension + ")"));
    }

    @Override
    public JComponent addComponent() {
        CBButton btnView = new CBButton(CBIntText.get("Launch"), CBIntText.get(""));
        btnView.setToolTipText(CBIntText.get("Launch the saved file into it's default application."));
        btnView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                baseodmediaeditor.this.launch();
            }
        });
        if (System.getProperty("os.name").equalsIgnoreCase("SunOS")) {
            return null;
        }
        return btnView;
    }

    public void launch() {
        if (this.bytes == null) {
            log.warning("No file to launch via " + this.fileName + ".");
            return;
        }
        File dir = new File("temp");
        dir.mkdir();
        dir.deleteOnExit();
        this.file = new File(dir, this.fileName + this.extension);
        this.file.deleteOnExit();
        try {
            FileOutputStream output = new FileOutputStream(this.file);
            output.write(this.bytes);
            output.close();
        }
        catch (IOException e) {
            CBUtility.error("Error writing to the file!" + e);
        }
        CBLauncher.launchProgram(this.extension, this.file.getPath());
    }

    @Override
    public void quit() {
        if (this.file != null) {
            this.file.delete();
        }
    }
}

