/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataQuery;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapContext;

public class OfflineDataBroker
extends DataBroker {
    HashMap<String, Node> nodes = new HashMap(1000);
    File ldifFile;
    private static Logger log = Logger.getLogger(OfflineDataBroker.class.getName());

    public void setLdifFile(File file) {
        this.ldifFile = file;
    }

    public void clear() {
        this.nodes.clear();
    }

    public DXNamingEnumeration children(DN nodeDN) {
        Node N = this.nodes.get(nodeDN.toString());
        return N == null ? null : N.getChildren();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public boolean hasData() {
        return !this.nodes.isEmpty();
    }

    public Vector objectClasses() {
        return null;
    }

    public Vector recommendedObjectClasses(DN dn) {
        return null;
    }

    @Override
    public SchemaOps getSchemaOps() {
        return null;
    }

    protected boolean addNode(DXEntry entry) {
        DN nodeDN = entry.getDN();
        log.fine("adding node " + nodeDN);
        Node N = new Node(entry);
        this.nodes.put(nodeDN.toString(), N);
        Node P = N.getParent();
        if (P == null && nodeDN.size() > 1) {
            this.addNode(new DXEntry(new DXAttributes(new DXAttribute("structuralTreeNode", "true")), nodeDN.getParent()));
            P = this.nodes.get(nodeDN.getParent().toString());
        }
        log.fine("parent = " + (P == null ? "null" : P.toString()));
        if (P != null) {
            P.addChild(N);
        }
        return true;
    }

    public boolean updateNode(DXEntry oldSet, DXEntry newSet) throws NamingException {
        log.fine("offline cache updating " + oldSet.getDN().toString());
        Node N = this.nodes.get(oldSet.getDN().toString());
        if (N == null) {
            return false;
        }
        N.updateAttributes(newSet);
        if (!oldSet.getDN().equals(newSet.getDN())) {
            this.move(oldSet.getDN(), newSet.getDN());
        }
        return true;
    }

    public boolean deleteTree(DN nodeDN) {
        log.fine("offline cache deleting " + nodeDN.toString());
        Node N = this.nodes.get(nodeDN.toString());
        if (N == null) {
            return false;
        }
        NamingEnumeration children = N.getChildNodes();
        while (children.hasMoreElements()) {
            this.deleteTree(((Node)children.nextElement()).getDN());
        }
        this.nodes.remove(nodeDN.toString());
        Node parent = N.getParent();
        if (parent != null) {
            parent.removeChild(N);
        }
        return true;
    }

    public void move(DN oldNodeDN, DN newNodeDN) throws NamingException {
        this.unthreadedCopy(oldNodeDN, newNodeDN);
        this.deleteTree(oldNodeDN);
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public LdapContext getLdapContext() {
        return null;
    }

    @Override
    public DataQuery doListQuery(DataQuery request) {
        request.setEnumeration(this.children(request.requestDN()));
        return request;
    }

    @Override
    public DataQuery doSearchQuery(DataQuery request) {
        request.setException(new Exception("offline searches not allowed"));
        return request;
    }

    public DataQuery doGetAllOCsQuery(DataQuery request) {
        request.setException(new Exception("offline object class list not implemented"));
        return request;
    }

    @Override
    public DataQuery doGetRecOCsQuery(DataQuery request) {
        request.setException(new Exception("offline object class list not implemented"));
        return request;
    }

    @Override
    public DXNamingEnumeration unthreadedList(DN searchbase) {
        return this.children(searchbase);
    }

    @Override
    public DXNamingEnumeration unthreadedSearch(DN dn, String filter, int search_level, String[] returnAttributes) {
        return null;
    }

    @Override
    public void unthreadedCopy(DN oldNodeDN, DN newNodeDN) throws NamingException {
        if (oldNodeDN == null) {
            throw new NamingException("null old dn passed to unthreadedCopy() in OfflineDataBroker");
        }
        Node Old = this.nodes.get(oldNodeDN.toString());
        if (Old == null) {
            throw new NamingException("null old Node found to unthreadedCopy() in OfflineDataBroker");
        }
        DXEntry newEntry = new DXEntry(Old.getEntry(), newNodeDN);
        this.forceAttributesToDN(newEntry);
        this.addNode(newEntry);
        Node New = this.nodes.get(newNodeDN.toString());
        NamingEnumeration children = Old.getChildNodes();
        while (children.hasMoreElements()) {
            Node child = (Node)children.nextElement();
            DN NewChildDN = new DN(New.getDN());
            NewChildDN.addChildRDN(child.getDN().getLowestRDN().toString());
            this.unthreadedCopy(child.getDN(), NewChildDN);
        }
    }

    public void forceAttributesToDN(DXEntry entry) throws NamingException {
        RDN rdn = entry.getRDN();
        for (int i = 0; i < rdn.size(); ++i) {
            String id = rdn.getAttID(i);
            DXAttribute oldAtt = entry.get(id);
            if (oldAtt != null && oldAtt.size() == 1) {
                entry.remove(id);
            }
            entry.put(id, rdn.getRawVal(i));
        }
    }

    @Override
    public boolean unthreadedExists(DN nodeDN) {
        return this.nodes.containsKey(nodeDN.toString());
    }

    public Vector unthreadedGetAllOCs() {
        return null;
    }

    @Override
    public DXEntry unthreadedReadEntry(DN entryDN, String[] returnAttributes) {
        Node N;
        if (returnAttributes != null) {
            log.info("warning: att list read entries not implemented in offline broker");
        }
        return (N = this.nodes.get(entryDN.toString())) == null ? new DXEntry(entryDN) : N.getEntry();
    }

    @Override
    public void unthreadedModify(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        if (oldEntry != null || newEntry != null) {
            if (oldEntry == null) {
                this.addNode(newEntry);
            } else if (newEntry == null) {
                this.deleteTree(oldEntry.getDN());
            } else {
                this.adjustEntriesForNameChanges(oldEntry, newEntry);
                this.updateNode(oldEntry, newEntry);
            }
        }
    }

    public void adjustEntriesForNameChanges(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        DN newDN;
        RDN oldRDN = oldEntry.getRDN();
        DN oldDN = oldEntry.getDN();
        if (oldDN.equals(newDN = newEntry.getDN())) {
            return;
        }
        if (this.unthreadedExists(newDN)) {
            throw new NamingException(CBIntText.get("The name: ''{0}'' already exists - please choose a different name", new String[]{newDN.getLowestRDN().toString()}));
        }
        for (int i = 0; i < oldRDN.size(); ++i) {
            String type = oldRDN.getAttID(i);
            String value = oldRDN.getRawVal(i);
            DXAttribute oldNamingAttInNewEntry = newEntry.get(type);
            if (oldNamingAttInNewEntry == null || oldNamingAttInNewEntry.contains(value)) continue;
            oldEntry.get(type).remove(value);
        }
    }

    @Override
    public ArrayList unthreadedGetRecOCs(DN dn) {
        return null;
    }

    @Override
    public String id() {
        return "OfflineDataBroker " + this.id;
    }

    class Node {
        DXEntry entry;
        ArrayList<Node> children;
        NameClassPair namePair;

        public Node(DXEntry entry) {
            this.entry = entry;
            DN dn = entry.getDN();
            this.children = new ArrayList(10);
            this.namePair = new NameClassPair(dn.getLowestRDN().toString(), dn.getLowestRDN().getAttID());
        }

        public void addChild(Node n) {
            this.children.add(n);
        }

        public void removeChild(Node n) {
            this.children.remove(n);
        }

        public void updateAttributes(DXAttributes a) {
            try {
                NamingEnumeration attset = a.getAll();
                while (attset.hasMore()) {
                    this.entry.put((Attribute)attset.next());
                }
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "unusual error in OfflineDataBroker::updateAttributes", e);
            }
        }

        public DXNamingEnumeration getChildren() {
            DXNamingEnumeration result = new DXNamingEnumeration();
            for (int i = 0; i < this.children.size(); ++i) {
                result.add(this.children.get(i).getNameClassPair());
            }
            return result;
        }

        public NamingEnumeration getChildNodes() {
            DXNamingEnumeration result = new DXNamingEnumeration();
            for (int i = 0; i < this.children.size(); ++i) {
                result.add(this.children.get(i));
            }
            return result;
        }

        public NameClassPair getNameClassPair() {
            return this.namePair;
        }

        public DXEntry getEntry() {
            return this.entry;
        }

        public DN getDN() {
            return this.entry.getDN();
        }

        public Node getParent() {
            DN parentDN = this.getDN().getParent();
            if (parentDN == null) {
                return null;
            }
            Node Parent = OfflineDataBroker.this.nodes.get(parentDN.toString());
            return Parent;
        }

        public String toString() {
            return this.getDN().toString();
        }
    }
}

