/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBClassLoader;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJarResource;
import com.ca.commons.cbutil.CBResourceLoader;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.commons.jndi.JndiSocketFactory;
import com.ca.directory.jxplorer.BatchJob;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorerBrowser;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class JXplorer {
    private ArrayList<JXplorerBrowser> browsers;
    CBResourceLoader resourceLoader;
    CBClassLoader classLoader;
    protected CBHelpSystem helpSystem;
    public static String APPLICATION_NAME = "jxplorer";
    private static Logger log = Logger.getLogger(JXplorer.class.getName());
    private boolean batchMode = false;

    public static void main(String[] args) {
        JXplorer.printTime("main start");
        log.fine("running JXplorer version " + JXConfig.version);
        if (!JXplorer.checkJavaEnvironment()) {
            System.exit(-1);
        }
        boolean batch = false;
        if (args.length > 0) {
            JXplorer.runBatchJob(args);
        } else {
            new JXplorer(false);
        }
        JXplorer.printTime("main end");
    }

    public JXplorer(boolean runInBatchMode) {
        this.batchMode = runInBatchMode;
        if (this.batchMode) {
            this.JXplorerInitResources();
        } else {
            this.JXplorerFullInit();
        }
    }

    protected void JXplorerFullInit() {
        JWindow splash = new JWindow();
        this.showSplashScreen(splash);
        this.JXplorerInitResources();
        this.setupHelp();
        this.browsers = new ArrayList();
        this.createInitialWindows();
        this.initUtilityFtns();
        splash.dispose();
    }

    protected void JXplorerInitResources() {
        this.copyDefaultFiles();
        JXConfig.setupProperties();
        JXConfig.setupLogger();
        this.setupResourceFiles();
        this.setupLanguage();
        if (!JXplorer.checkFileEnvironment()) {
            return;
        }
    }

    protected void setupLanguage() {
        String localeString = JXConfig.getProperty("force.locale");
        if (localeString == null || localeString.equals("default")) {
            CBIntText.init("language.JX", this.classLoader);
        } else {
            String[] elements = localeString.split("\\.");
            Locale newLocale = null;
            switch (elements.length) {
                case 1: {
                    newLocale = new Locale(elements[0]);
                    break;
                }
                case 2: {
                    newLocale = new Locale(elements[0], elements[1]);
                    break;
                }
                case 3: {
                    newLocale = new Locale(elements[0], elements[1], elements[2]);
                    break;
                }
                default: {
                    log.severe("unable to parse locale element " + localeString);
                }
            }
            CBIntText.init("language.JX", this.classLoader, newLocale);
        }
    }

    public static void printTime(String msg) {
        long time = System.currentTimeMillis();
        log.info(msg + "\nTIME: " + new Date().toString() + "  (" + time % 1000L + ")\n");
    }

    public void initUtilityFtns() {
        if (this.browsers.size() > 0) {
            CBUtility.initDefaultDisplay(this.browsers.get(0));
        }
    }

    public static boolean checkJavaEnvironment() {
        log.info("running java from: " + System.getProperty("java.home"));
        String javaVersion = System.getProperty("java.version");
        log.info("running java version " + javaVersion);
        if (javaVersion.compareTo("1.5") < 0) {
            log.severe(CBIntText.get("TERMINATING: JXplorer requires Security Extensions and other features found only in java 1.5.0 or better."));
            JOptionPane.showMessageDialog(null, CBIntText.get("TERMINATING: JXplorer requires java 1.5.0 or better"), CBIntText.get("The Current Java Version is {0}", new String[]{javaVersion}), 0);
            return false;
        }
        return true;
    }

    public static boolean checkFileEnvironment() {
        return true;
    }

    protected void setupHelp() {
        this.helpSystem = new CBHelpSystem("JXplorerHelp.hs", new Dimension(1000, 600));
    }

    public CBHelpSystem getHelpSystem() {
        return this.helpSystem;
    }

    public static ImageIcon getImageIcon(String name) {
        ImageIcon newIcon = new ImageIcon(Theme.getInstance().getDirImages() + name);
        return newIcon;
    }

    private static String getBrowserSuffix(int browserNo) {
        return browserNo > 0 ? "-" + browserNo : "";
    }

    public String toString() {
        return "JXplorer version " + JXConfig.version;
    }

    public void showSplashScreen(JWindow splash) {
        ImageIcon splashIcon = new ImageIcon(Theme.getInstance().getDirTemplates() + "JXsplash.png");
        int width = splashIcon.getIconWidth();
        int height = splashIcon.getIconHeight();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        splash.setBounds((screen.width - width) / 2, (screen.height - height) / 2, width, height);
        JLabel pic = new JLabel(splashIcon);
        JPanel content = (JPanel)splash.getContentPane();
        content.add(pic);
        splash.setVisible(true);
    }

    public void setupResourceFiles() {
        this.resourceLoader = new CBResourceLoader();
        this.classLoader = new CBClassLoader(this.resourceLoader);
        String pluginPath = JXConfig.getProperty("dir.plugins");
        String[] pluginFiles = CBUtility.readFilteredDirectory(pluginPath, new String[]{"zip", "jar"});
        if (pluginFiles == null) {
            log.warning("Unable to access plugins directory: '" + pluginPath + "'");
            return;
        }
        for (int i = 0; i < pluginFiles.length; ++i) {
            this.resourceLoader.addResource(new CBJarResource(pluginPath + pluginFiles[i]));
        }
        this.setupSecurityProviders();
        this.setupGSSAPIConfig();
    }

    protected void setupGSSAPIConfig() {
        try {
            String sep = System.getProperty("line.separator");
            String defaultFileText = "com.ca.commons.jndi.JNDIOps {" + sep + "  com.sun.security.auth.module.Krb5LoginModule required client=TRUE" + sep + "  \t\t\t\t\t\t\t\t\t\t\t\t\t\tuseTicketCache=TRUE;" + sep + "};";
            String configFile = CBUtility.getPropertyConfigPath(APPLICATION_NAME, "gssapi.conf");
            File gssapi_conf = new File(configFile);
            if (!gssapi_conf.exists()) {
                FileWriter confWriter = new FileWriter(gssapi_conf);
                confWriter.write(defaultFileText);
                confWriter.close();
            }
            System.setProperty("java.security.auth.login.config", gssapi_conf.getCanonicalPath().toString());
        }
        catch (IOException e) {
            log.warning("ERROR: Unable to initialise GSSAPI config file " + e);
        }
    }

    protected void setupSecurityProviders() {
        String providerName = JXConfig.getProperty("securityProvider2", null);
        if (providerName != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXConfig.getProperty("securityProvider1", null)) != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXConfig.getProperty("securityProvider0", null)) != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXConfig.getProperty("securityProvider", null)) != null) {
            this.addSecurityProvider(providerName);
        }
        if ((providerName = JXConfig.getProperty("securityProvider3", null)) != null) {
            CBUtility.error(CBIntText.get("Too many security providers in config file."));
            JXplorer.printSecurityProviders();
        } else if (JXConfig.debugLevel >= 2) {
            JXplorer.printSecurityProviders();
        }
        JndiSocketFactory.setClassLoader(this.classLoader);
    }

    protected void addSecurityProvider(String providerName) {
        try {
            Class<?> providerClass = this.classLoader.loadClass(providerName);
            Object providerObject = providerClass.newInstance();
            Security.insertProviderAt((Provider)providerObject, 1);
        }
        catch (Exception e) {
            System.err.println("\n*** unable to load new security provider: " + (providerName == null ? "null" : providerName));
            System.err.println(e);
        }
    }

    protected static void printSecurityProviders() {
        log.fine("\n***\n*** LIST OF CURRENT SECURITY PROVIDERS\n***");
        Provider[] current = Security.getProviders();
        for (int i = 0; i < current.length; ++i) {
            log.fine("provider: " + i + " = " + current[i].getName() + " " + current[i].getInfo());
            log.fine("   (" + current[i].getClass().toString() + ")\n");
        }
        log.fine("\n***\n*** END LIST\n***\n");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public CBResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public ArrayList<JXplorerBrowser> getBrowsers() {
        return this.browsers;
    }

    public void createInitialWindows() {
        int numWindows = JXConfig.getIntProperty("windows", 1);
        for (int browserNo = 0; browserNo < numWindows; ++browserNo) {
            String suffix = JXplorer.getBrowserSuffix(browserNo);
            int width = JXConfig.getIntProperty("width" + suffix);
            int height = JXConfig.getIntProperty("height" + suffix);
            int xpos = JXConfig.getIntProperty("xpos" + suffix);
            int ypos = JXConfig.getIntProperty("ypos" + suffix);
            JXplorerBrowser browser = this.createNewBrowser(xpos, ypos, width, height);
            int treeWidth = JXConfig.getIntProperty("treewidth" + suffix, 320);
            browser.getSplitPane().setDividerLocation(treeWidth);
        }
    }

    public JXplorerBrowser createNewBrowser() {
        int ypos;
        int xpos;
        int height;
        int width;
        try {
            width = JXConfig.getIntProperty("width");
            height = JXConfig.getIntProperty("height");
        }
        catch (Exception e) {
            width = 1000;
            height = 700;
        }
        if (width < 100) {
            width = 100;
        }
        if (height < 100) {
            height = 100;
        }
        try {
            xpos = JXConfig.getIntProperty("xpos");
            ypos = JXConfig.getIntProperty("ypos");
        }
        catch (Exception e) {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            xpos = (screen.width - width) / 2;
            ypos = (screen.height - height) / 2;
        }
        return this.createNewBrowser(xpos, ypos, width, height);
    }

    public JXplorerBrowser createNewBrowser(int xpos, int ypos, int width, int height) {
        JXplorerBrowser browser;
        boolean usingJXW = true;
        if (usingJXW) {
            try {
                Class<?> c = this.getClassLoader().loadClass("com.pegacat.jxworkbench.JXWBrowser");
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                browser = (JXplorerBrowser)constructor.newInstance(new Object[0]);
                log.info("JXWorkBench loaded");
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("JXWorkBench not available - loading standard JXplorer version");
                browser = new JXplorerBrowser();
            }
        } else {
            browser = new JXplorerBrowser();
        }
        browser.setBounds(xpos, ypos, width, height);
        browser.setSize(width, height);
        browser.init(this);
        this.browsers.add(browser);
        return browser;
    }

    public void shutdown() {
        this.shutdown(null);
    }

    public void shutdown(String msg) {
        JXConfig.setProperty("windows", String.valueOf(this.browsers.size()));
        for (int browserNo = 0; browserNo < this.browsers.size(); ++browserNo) {
            JXplorerBrowser browser = this.browsers.get(browserNo);
            String suffix = JXplorer.getBrowserSuffix(browserNo);
            JXConfig.setProperty("width" + suffix, String.valueOf((int)browser.getSize().getWidth()));
            JXConfig.setProperty("height" + suffix, String.valueOf((int)browser.getSize().getHeight()));
            JXConfig.setProperty("xpos" + suffix, String.valueOf(browser.getX()));
            JXConfig.setProperty("ypos" + suffix, String.valueOf(browser.getY()));
            JXConfig.setProperty("treewidth" + suffix, String.valueOf(browser.getSplitPane().getDividerLocation()));
            JXConfig.setProperty("last.search.filter", "default");
        }
        JXConfig.writePropertyFile();
        if (msg != null) {
            log.severe("shutting down\n" + msg);
        } else {
            log.warning("shutting down");
        }
        System.exit(0);
    }

    public void browserClosing(JXplorerBrowser closingBrowser) {
        if (this.browsers.size() > 1) {
            this.browsers.remove(closingBrowser);
            this.initUtilityFtns();
        } else {
            this.shutdown();
        }
    }

    public void setPopupToolPasteOptions(boolean active) {
        if (this.browsers.size() > 1) {
            for (JXplorerBrowser browser : this.browsers) {
                ButtonRegister br = browser.getButtonRegister();
                br.setItemEnabled("PASTE", active);
                br.setItemEnabled("PASTE_ALIAS", active);
            }
        }
    }

    private void copyDefaultFiles() {
        this.checkAndCopy("csvconfig.txt.default");
        this.checkAndCopy("security.default");
    }

    private void checkAndCopy(String sourceFileName) {
        File destinationFile;
        File sourceFile = new File(JXConfig.getLocalDirectory() + sourceFileName);
        String destinationFileName = sourceFileName;
        if (sourceFileName.endsWith(".default")) {
            destinationFileName = sourceFileName.substring(0, sourceFileName.length() - 8);
        }
        if (!(destinationFile = new File(JXConfig.getConfigDirectory() + destinationFileName)).isDirectory() && destinationFile.exists()) {
            return;
        }
        if (!sourceFile.exists()) {
            log.warning("Unable to find default file: " + sourceFile + " -> not copying to : " + destinationFile);
            return;
        }
        log.fine("COPYING resource file: " + sourceFile.getAbsolutePath() + " to " + destinationFile.getAbsolutePath());
        this.recursivelyCopyFile(sourceFile, destinationFile);
    }

    private void recursivelyCopyFile(File sourceFile, File destinationFile) {
        try {
            if (sourceFile.isDirectory()) {
                String[] children;
                if (!destinationFile.exists() && !destinationFile.mkdirs()) {
                    log.severe("unable to set up destination directory for config files: " + destinationFile.getAbsolutePath());
                    return;
                }
                for (String child : children = sourceFile.list()) {
                    if (child.startsWith(".")) continue;
                    this.recursivelyCopyFile(new File(sourceFile + File.separator + child), new File(destinationFile + File.separator + child));
                }
            } else {
                if (destinationFile.exists()) {
                    return;
                }
                CBUtility.copyFile(sourceFile, destinationFile);
                System.out.println("copying: " + sourceFile + " -> to : " + destinationFile);
            }
        }
        catch (IOException e) {
            log.severe("unable to setup default files; couldn't copy " + sourceFile.getAbsolutePath() + " to " + destinationFile.getAbsolutePath() + "\n error was; " + e.getMessage());
        }
    }

    private static void runBatchJob(String[] args) {
        try {
            if (args[0].contains("report")) {
                JXplorer jx = new JXplorer(true);
                Class<?> c = jx.getClassLoader().loadClass("com.pegacat.jxworkbench.reports.JXWBatchReport");
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                BatchJob reportEngine = (BatchJob)constructor.newInstance(new Object[0]);
                reportEngine.execute(jx, args);
            } else {
                JXplorer.printHelpAndExit();
            }
        }
        catch (Exception e) {
            System.out.println("BATCH JOB FAILED DUE TO ERROR");
            e.printStackTrace();
        }
    }

    private static void printHelpAndExit() {
        System.out.println("BATCH MODE USAGE\nCurrently only the -report option is supported for JXWorkBench batch reporting.\n(For more information try -report -help");
    }
}

