/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.cbutil.CBParse;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.Name;
import com.ca.commons.security.cert.extensions.IssuerAltName;
import com.ca.commons.security.cert.extensions.V3Extension;
import java.math.BigInteger;

public class AuthorityKeyIdentifier
implements V3Extension {
    String value = null;
    BigInteger serialNumber;
    byte[] keyId;

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public byte[] getKeyId() {
        return this.keyId;
    }

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for AuthorityKeyIdentifier");
        }
        for (int i = 0; i < asn1object.size(); ++i) {
            ASN1Object compBig = asn1object.getComponent(i);
            ASN1Object nextComp = (ASN1Object)compBig.getValue();
            if (nextComp.isASN1Type(ASN1Type.OCTET_STRING) && i == 0) {
                this.keyId = (byte[])nextComp.getValue();
                this.value = "KeyID: " + CBParse.bytes2HexSplit(this.keyId, 4);
                continue;
            }
            if (nextComp.isASN1Type(ASN1Type.OCTET_STRING)) {
                this.value = this.value == null ? "Authority Cert SerialNumber: " + CBParse.bytes2HexSplit((byte[])nextComp.getValue(), 4) : this.value + "\nAuthority Cert SerialNumber: " + CBParse.bytes2HexSplit((byte[])nextComp.getValue(), 4);
                this.serialNumber = new BigInteger((byte[])nextComp.getValue());
                continue;
            }
            ASN1Object gnames = (ASN1Object)nextComp.getValue();
            IssuerAltName ian = new IssuerAltName();
            ian.init(gnames);
            String gnamesString = ian.toString();
            if (gnamesString.startsWith("Unrecognised")) {
                gnamesString = "Directory Address: " + IssuerAltName.cleanName(new Name(gnames).toString());
            }
            this.value = this.value == null ? gnamesString : this.value + "\n" + gnamesString;
        }
    }

    public String toString() {
        return this.value;
    }
}

